/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.PrintStream;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.JELUtils;
import uk.ac.starlink.ttools.filter.DummyJELRowReader;

public class Calc
implements Task {
    private final Parameter exprParam_ = new Parameter("expression");

    public Calc() {
        this.exprParam_.setPosition(1);
        this.exprParam_.setUsage("<expr>");
        this.exprParam_.setPrompt("Expression to evaluate");
        this.exprParam_.setDescription(new String[]{"An expression to evaluate.", "The functions in <ref id='staticMethods'/> can be used."});
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.exprParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        CompiledExpression compEx;
        ColumnStarTable dummyTable = ColumnStarTable.makeTableWithRows(0L);
        final DummyJELRowReader rdr = new DummyJELRowReader(dummyTable);
        Library lib = JELUtils.getLibrary(rdr);
        String expr = this.exprParam_.stringValue(env);
        final PrintStream out = env.getOutputStream();
        try {
            compEx = Evaluator.compile(expr, lib);
        }
        catch (CompilationException e) {
            throw new TaskException("Bad expression \"" + expr + "\": " + e.getMessage(), (Throwable)e);
        }
        return new Executable(){

            public void execute() throws TaskException {
                out.println("   " + this.evaluate());
            }

            private Object evaluate() throws TaskException {
                try {
                    return compEx.evaluate(new Object[]{rdr});
                }
                catch (NullPointerException e) {
                    return null;
                }
                catch (Throwable e) {
                    String msg = e.getMessage();
                    msg = msg == null ? "Execution error: " + e.toString() : "Execution error: " + msg;
                    throw new TaskException(msg, e);
                }
            }
        };
    }
}

