/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.ObjectFactory;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.MultiParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class FilterParameter
extends Parameter
implements ExtraParameter,
MultiParameter {
    private ProcessingStep[] steps_;

    public FilterParameter(String name) {
        super(name);
        this.setUsage("<cmds>");
        this.setNullPermitted(true);
        this.setDescription(new String[]{"The value of this parameter is one or more of the filter commands", "described in <ref id=\"filterSteps\"/>.", "If more than one is given, they must be separated by", "semicolon characters (\";\").", "This parameter can be repeated multiple times on the same", "command line to build up a list of processing steps.", "The sequence of commands given in this way", "defines the processing pipeline which is performed on the table."});
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        this.steps_ = sval != null ? StepFactory.getInstance().createSteps(sval) : new ProcessingStep[0];
        super.setValueFromString(env, sval);
    }

    public ProcessingStep[] stepsValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.steps_;
    }

    public String getExtraUsage(TableEnvironment env) {
        return FilterParameter.getFiltersUsage(env);
    }

    public static String getFiltersUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer().append("   Known filter commands:\n");
        ObjectFactory filterFactory = StepFactory.getInstance().getFilterFactory();
        String[] fnames = filterFactory.getNickNames();
        int i = 0;
        while (i < fnames.length) {
            block4: {
                String fname = fnames[i];
                try {
                    ProcessingFilter filter = (ProcessingFilter)filterFactory.createObject(fname);
                    String fusage = filter.getUsage();
                    sbuf.append("      ").append(fname);
                    String pad = ("      " + fname).replaceAll(".", " ");
                    if (fusage != null) {
                        sbuf.append(' ').append(fusage.replaceAll("\n", "\n " + pad));
                    }
                    sbuf.append('\n');
                }
                catch (LoadException e) {
                    if (!env.isDebug()) break block4;
                    sbuf.append("    ( ").append(fname).append(" - not available: ").append(e).append(" )\n");
                }
            }
            ++i;
        }
        sbuf.append("\n").append("   Commands can be separated on one line using ").append("semicolons (;).\n").append("   Arguments containing spaces should be ").append("'quoted' or \"quoted\".\n");
        return sbuf.toString();
    }
}

