/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.StreamRowStore;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.DataSource;

public class InputTableParameter
extends Parameter {
    private InputFormatParameter formatParam_;
    private BooleanParameter streamParam_;
    private StarTable table_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$task$InputTableParameter;

    public InputTableParameter(String name) {
        super(name);
        this.setUsage("<in-table>");
        String suffix = name.startsWith("in") ? name.substring(2) : "";
        this.formatParam_ = new InputFormatParameter("ifmt" + suffix);
        this.streamParam_ = new BooleanParameter("istream" + suffix);
        this.setDescription(new String[]{"The location of the input table.", "This is usually a filename or URL, and may point to a file", "compressed in one of the supported compression formats", "(Unix compress, gzip or bzip2).", "If it is omitted, or equal to the special value \"-\",", "the input table will be read from standard input.", "In this case the input format must be given explicitly", "using the <code>" + this.formatParam_.getName() + "</code> parameter."});
        this.streamParam_.setDescription(new String[]{"If set true, the <code>" + this.getName() + "</code> table", "will be read as a stream.", "It is necessary to give the ", "<code>" + this.formatParam_.getName() + "</code> parameter", "in this case.", "Depending on the required operations and processing mode,", "this may cause the read to fail (sometimes it is necessary", "to read the input table more than once).", "It is not normally useful or necessary to set this flag -", "in most cases the data will be streamed automatically", "if that is the best thing to do."});
    }

    public InputFormatParameter getFormatParameter() {
        return this.formatParam_;
    }

    public BooleanParameter getStreamParameter() {
        return this.streamParam_;
    }

    public StarTable tableValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        if (this.table_ == null) {
            try {
                String loc = this.stringValue(env);
                String fmt = this.formatParam_.stringValue(env);
                boolean stream = this.streamParam_.booleanValue(env);
                StarTableFactory tfact = this.getTableFactory(env);
                if (stream || loc.equals("-")) {
                    BufferedInputStream in = new BufferedInputStream(DataSource.getInputStream(loc));
                    this.table_ = this.getStreamedTable(tfact, in, fmt);
                } else {
                    this.table_ = tfact.makeStarTable(loc, fmt);
                }
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        return this.table_;
    }

    void setValueFromTable(StarTable table) {
        this.table_ = table;
        this.setGotValue(true);
    }

    StarTable getStreamedTable(StarTableFactory tfact, final InputStream in, String inFmt) throws IOException {
        if (inFmt == null) {
            throw new IOException("Must specify input format for streamed table");
        }
        final TableBuilder tbuilder = tfact.getTableBuilder(inFmt);
        if (!$assertionsDisabled && tbuilder == null) {
            throw new AssertionError();
        }
        final StreamRowStore streamStore = new StreamRowStore(1024);
        Thread streamer = new Thread("Table Streamer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block8: {
                    tbuilder.streamStarTable(in, streamStore, null);
                    Object var3_1 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {}
                    break block8;
                    {
                        catch (IOException e) {
                            streamStore.setError(e);
                            Object var3_2 = null;
                            try {
                                in.close();
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        };
        streamer.setDaemon(true);
        streamer.start();
        return streamStore.waitForStarTable();
    }

    private StarTableFactory getTableFactory(Environment env) {
        return TableEnvironment.getTableFactory(env);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$task$InputTableParameter == null ? (class$uk$ac$starlink$ttools$task$InputTableParameter = InputTableParameter.class$("uk.ac.starlink.ttools.task.InputTableParameter")) : class$uk$ac$starlink$ttools$task$InputTableParameter).desiredAssertionStatus();
    }
}

