/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;

public class JoinTypeParameter
extends ChoiceParameter {
    private static final String[] CHOICES;

    public JoinTypeParameter(String name) {
        super(name, CHOICES);
        StringBuffer items = new StringBuffer();
        JoinType[] joins = JoinType.getPairTypes();
        int i = 0;
        while (i < joins.length) {
            JoinType join = joins[i];
            items.append("<li><code>").append(join.getName()).append("</code>: ").append(join.getDescription()).append("</li>\n");
            ++i;
        }
        this.setDescription(new String[]{"Determines which rows are included in the output table.", "The matching algorithm determines which of the rows from", "the first table correspond to which rows from the second.", "This parameter determines what to do with that information.", "Perhaps the most obvious thing is to write out a table", "containing only rows which correspond to a row in both of", "the two input tables.  However, you may also want to see", "the unmatched rows from one or both input tables,", "or rows present in one table but unmatched in the other,", "or other possibilities.", "The options are:", "<ul>", items.toString(), "</ul>"});
        this.setUsage("<join-type>");
    }

    public JoinType joinTypeValue(Environment env) throws TaskException {
        String sval = this.stringValue(env);
        JoinType[] joins = JoinType.getPairTypes();
        int i = 0;
        while (i < joins.length) {
            if (joins[i].getName().toLowerCase().equals(sval)) {
                return joins[i];
            }
            ++i;
        }
        throw new UsageException("Unknown join type " + sval);
    }

    static {
        JoinType[] joins = JoinType.getPairTypes();
        CHOICES = new String[joins.length];
        int i = 0;
        while (i < joins.length) {
            JoinTypeParameter.CHOICES[i] = joins[i].getName();
            ++i;
        }
    }
}

