/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.ttools.task.MultiParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class LineEnvironment
extends TableEnvironment {
    private Argument[] arguments_;
    private int narg_;
    private int numberedArgs_;
    private boolean interactive_ = true;
    private boolean promptAll_;
    private Set clearedParams_ = new HashSet();
    private List acquiredValues_ = new ArrayList();
    private static final String NULL_STRING = "";

    public void setArgs(String[] args) {
        if (this.arguments_ != null) {
            throw new IllegalStateException("Arguments already set");
        }
        this.arguments_ = new Argument[args.length];
        int i = 0;
        while (i < args.length) {
            this.arguments_[i] = new Argument(args[i]);
            ++i;
        }
    }

    public void setInteractive(boolean interactive) {
        this.interactive_ = interactive;
    }

    public boolean getInteractive() {
        return this.interactive_;
    }

    public void setPromptAll(boolean prompt) {
        if (!this.interactive_) {
            throw new IllegalStateException("Not interactive");
        }
        this.promptAll_ = prompt;
    }

    public boolean getPromptAll() {
        return this.promptAll_;
    }

    private String findValue(Parameter param) {
        if (param instanceof MultiParameter) {
            StringBuffer val = new StringBuffer();
            int igot = 0;
            int i = 0;
            while (i < this.arguments_.length) {
                Argument arg = this.arguments_[i];
                if (param.getName().equals(arg.name_) || arg.pos_ > 0 && param.getPosition() == arg.pos_) {
                    arg.used_ = true;
                    if (igot++ > 0) {
                        val.append(';');
                    }
                    val.append(arg.value_);
                }
                ++i;
            }
            if (igot > 0) {
                return val.toString();
            }
        } else {
            int i = 0;
            while (i < this.arguments_.length) {
                Argument arg = this.arguments_[i];
                if (param.getName().equals(arg.name_) || arg.pos_ > 0 && param.getPosition() == arg.pos_) {
                    arg.used_ = true;
                    return arg.value_;
                }
                ++i;
            }
        }
        return null;
    }

    private String promptForValue(Parameter param) throws TaskException {
        String name = param.getName();
        String prompt = param.getPrompt();
        String dflt = param.getDefault();
        StringBuffer obuf = new StringBuffer(param.getName());
        if (prompt != null) {
            obuf.append(" - ").append(prompt);
        }
        if (dflt != null || param.isNullPermitted()) {
            obuf.append(" [").append(dflt).append("]");
        }
        obuf.append(": ");
        String promptLine = obuf.toString();
        int ntry = 0;
        while (ntry < 5) {
            String sval;
            try {
                PrintStream err = this.getErrorStream();
                sval = this.isHidden(param) ? TerminalAuthenticator.readMaskedString(promptLine, err) : TerminalAuthenticator.readString(promptLine, err);
            }
            catch (IOException e) {
                throw new TaskException("Prompt for value failed");
            }
            if ("?".equals(sval) || "help".equalsIgnoreCase(sval)) {
                this.getErrorStream().println();
                this.getErrorStream().println(LineInvoker.getParamHelp(this, null, param));
            } else {
                String stringVal;
                String string = stringVal = sval.length() == 0 ? param.getDefault() : LineEnvironment.readValue(sval);
                if (NULL_STRING.equals(stringVal)) {
                    stringVal = null;
                }
                try {
                    this.setValueFromString(param, stringVal);
                    return stringVal;
                }
                catch (TaskException e) {
                    this.getErrorStream().println(e.getMessage() + "\n");
                }
            }
            ++ntry;
        }
        throw new ParameterValueException(param, "Too many tries");
    }

    private String readString(String prompt) throws IOException {
        this.getErrorStream().print(prompt);
        this.getErrorStream().flush();
        StringBuffer ibuf = new StringBuffer();
        boolean done = false;
        while (!done) {
            int c = System.in.read();
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    done = true;
                    break;
                }
                default: {
                    ibuf.append((char)c);
                }
            }
        }
        return ibuf.toString();
    }

    public void clearValue(Parameter par) {
        this.clearedParams_.add(par);
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public PrintStream getErrorStream() {
        return System.err;
    }

    public void acquireValue(Parameter param) throws TaskException {
        String stringVal;
        if (this.clearedParams_.contains(param)) {
            stringVal = null;
            this.clearedParams_.remove(param);
        } else {
            stringVal = this.findValue(param);
        }
        if (stringVal != null) {
            if (stringVal.equals(NULL_STRING)) {
                stringVal = null;
            }
            this.setValueFromString(param, stringVal);
        } else if (this.interactive_ && (this.promptAll_ || param.getDefault() == null && !param.isNullPermitted() || param.getPreferExplicit())) {
            stringVal = this.promptForValue(param);
        } else {
            stringVal = param.getDefault();
            this.setValueFromString(param, stringVal);
        }
        String word = this.formatAssignment(param, stringVal);
        if (!this.acquiredValues_.contains(word)) {
            this.acquiredValues_.add(word);
        }
    }

    private void setValueFromString(Parameter param, String sval) throws TaskException {
        if (sval == null && !param.isNullPermitted()) {
            throw new ParameterValueException(param, "null value not allowed");
        }
        param.setValueFromString((Environment)this, sval);
    }

    private boolean isHidden(Parameter param) {
        return param.getName().equals("password");
    }

    private String formatAssignment(Parameter param, String value) {
        if (value != null && value.indexOf(32) >= 0) {
            if (value.indexOf(39) < 0) {
                value = '\'' + value + '\'';
            } else if (value.indexOf(34) < 0) {
                value = '\"' + value + '\"';
            }
        }
        if (this.isHidden(param)) {
            value = "*";
        }
        return param.getName() + "=" + value;
    }

    public String[] getUnused() {
        ArrayList<String> unusedList = new ArrayList<String>();
        int i = 0;
        while (i < this.arguments_.length) {
            Argument arg = this.arguments_[i];
            if (!arg.used_) {
                unusedList.add(arg.orig_);
            }
            ++i;
        }
        return unusedList.toArray(new String[0]);
    }

    public String[] getAssignments() {
        return this.acquiredValues_.toArray(new String[0]);
    }

    private static String readValue(String sval) {
        if (sval.length() == 0 || sval.equals("null")) {
            return NULL_STRING;
        }
        return sval;
    }

    private class Argument {
        final String orig_;
        final String name_;
        final int pos_;
        final String value_;
        boolean used_;

        Argument(String arg) {
            this.orig_ = arg;
            int epos = arg.indexOf(61);
            if (epos > 0) {
                this.name_ = arg.substring(0, epos);
                this.pos_ = -1;
                this.value_ = LineEnvironment.readValue(arg.substring(epos + 1));
            } else {
                this.pos_ = ++LineEnvironment.this.numberedArgs_;
                this.name_ = null;
                this.value_ = LineEnvironment.readValue(arg);
            }
        }
    }
}

