/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.ObjectFactory;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.LineEnvironment;
import uk.ac.starlink.ttools.task.LineFormatter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class LineInvoker {
    private final String toolName_;
    private final ObjectFactory taskFactory_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools");

    public LineInvoker(String toolName, ObjectFactory taskFactory) {
        this.toolName_ = toolName;
        this.taskFactory_ = taskFactory;
    }

    public void invoke(String[] args) {
        block38: {
            ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
            LineEnvironment env = new LineEnvironment();
            int verbosity = 0;
            Iterator it = argList.iterator();
            while (it.hasNext()) {
                String arg = (String)it.next();
                if (!arg.startsWith("-")) break;
                if (arg.equals("-help") || arg.equals("-h")) {
                    it.remove();
                    String topic = it.hasNext() ? (String)it.next() : null;
                    System.out.println("\n" + this.getUsage(topic));
                    return;
                }
                if (arg.equals("-version")) {
                    it.remove();
                    System.out.println("\nSTILTS version " + Stilts.getVersion() + "\n");
                    return;
                }
                if (arg.equals("-verbose")) {
                    it.remove();
                    ++verbosity;
                    continue;
                }
                if (arg.equals("-disk")) {
                    it.remove();
                    StoragePolicy.setDefaultPolicy(StoragePolicy.PREFER_DISK);
                    env.getTableFactory().setStoragePolicy(StoragePolicy.PREFER_DISK);
                    continue;
                }
                if (arg.equals("-votstrict")) {
                    it.remove();
                    env.setStrictVotable(true);
                    continue;
                }
                if (arg.equals("-novotstrict")) {
                    it.remove();
                    env.setStrictVotable(false);
                    continue;
                }
                if (arg.equals("-batch")) {
                    it.remove();
                    env.setInteractive(false);
                    continue;
                }
                if (arg.equals("-prompt")) {
                    it.remove();
                    env.setPromptAll(true);
                    continue;
                }
                if (arg.equals("-debug")) {
                    it.remove();
                    env.setDebug(true);
                    continue;
                }
                it.remove();
                System.err.println("\n" + this.getUsage());
                System.exit(1);
            }
            if (argList.size() == 0) {
                System.err.println("\n" + this.getUsage());
                System.exit(1);
            }
            LineInvoker.configureLogging(verbosity, env.isDebug());
            String taskName = (String)argList.remove(0);
            if (this.taskFactory_.isRegistered(taskName)) {
                Task task = null;
                try {
                    task = (Task)this.taskFactory_.createObject(taskName);
                    String[] taskArgs = argList.toArray(new String[0]);
                    String helpText = this.helpMessage(env, task, taskName, taskArgs);
                    if (helpText != null) {
                        System.out.println("\n" + helpText);
                        break block38;
                    }
                    env.setArgs(taskArgs);
                    Executable exec = task.createExecutable((Environment)env);
                    String[] unused = env.getUnused();
                    if (unused.length == 0) {
                        this.logParameterValues(taskName, env);
                        exec.execute();
                        break block38;
                    }
                    System.err.println("\n" + LineInvoker.getUnusedWarning(unused));
                    System.err.println(LineInvoker.getTaskUsage(task, taskName));
                    System.exit(1);
                }
                catch (TaskException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(System.err);
                    } else {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = e.toString();
                        }
                        System.err.println("\n" + msg + "\n");
                    }
                    if (e instanceof UsageException && task != null) {
                        System.err.println(LineInvoker.getTaskUsage(task, taskName));
                    }
                    System.exit(1);
                }
                catch (IllegalArgumentException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(System.err);
                    } else {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = e.toString();
                        }
                        System.err.println("\n" + msg + "\n");
                    }
                    System.exit(1);
                }
                catch (RuntimeException e) {
                    if (env.isDebug()) {
                        e.printStackTrace();
                    } else {
                        System.err.println("\n" + e + "\n");
                    }
                    System.exit(1);
                }
                catch (IOException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(System.err);
                    } else {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = e.toString();
                        }
                        System.err.println("\n" + msg + "\n");
                    }
                    System.exit(1);
                }
                catch (LoadException e) {
                    System.err.println("Task " + taskName + " not available");
                    if (e.getMessage() != null) {
                        System.err.println(e.getMessage() + "\n");
                    }
                    if (env.isDebug()) {
                        e.printStackTrace(System.err);
                    }
                    break block38;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("\nOut of memory");
                    if (env.getTableFactory().getStoragePolicy() != StoragePolicy.PREFER_DISK) {
                        System.err.println("Try \"-disk\" flag?\n");
                    } else {
                        System.err.println("Try increasing heap memory (-Xmx flag)\n");
                    }
                    if (env.isDebug()) {
                        e.printStackTrace(System.err);
                    }
                    break block38;
                }
            }
            System.err.println("\nNo such task: " + taskName);
            System.err.println("\n" + this.getUsage());
            System.exit(1);
        }
    }

    private void logParameterValues(String taskName, LineEnvironment env) {
        StringBuffer sbuf = new StringBuffer(taskName);
        String[] words = env.getAssignments();
        int i = 0;
        while (i < words.length) {
            sbuf.append(' ').append(words[i]);
            ++i;
        }
        logger_.info(sbuf.toString());
    }

    private String helpMessage(TableEnvironment env, Task task, String taskName, String[] taskArgs) {
        int i = 0;
        while (i < taskArgs.length) {
            String arg = taskArgs[i];
            String helpFor = null;
            if (arg.equals("-help") || arg.equals("-h") || arg.equalsIgnoreCase("help")) {
                return LineInvoker.getTaskUsage(task, taskName);
            }
            if (arg.toLowerCase().startsWith("-help=")) {
                helpFor = arg.substring(6).trim().toLowerCase();
            } else if (arg.toLowerCase().startsWith("help=")) {
                helpFor = arg.substring(5).trim().toLowerCase();
            } else if (arg.length() > 1 && arg.endsWith("=")) {
                helpFor = arg.substring(0, arg.length() - 1);
            } else if (arg.length() > 2 && arg.endsWith("=?")) {
                helpFor = arg.substring(0, arg.length() - 2);
            }
            if (helpFor != null) {
                Parameter[] params = task.getParameters();
                int j = 0;
                while (j < params.length) {
                    Parameter param = params[j];
                    if (helpFor.equals(param.getName())) {
                        return LineInvoker.getParamHelp(env, taskName, param);
                    }
                    ++j;
                }
                return "No such parameter: " + helpFor + "\n\n" + LineInvoker.getTaskUsage(task, taskName);
            }
            ++i;
        }
        return null;
    }

    private String getUsage(String topic) {
        if (topic != null) {
            try {
                Task task = (Task)this.taskFactory_.createObject(topic);
                return LineInvoker.getTaskUsage(task, topic);
            }
            catch (LoadException e) {
            }
        }
        return this.getUsage();
    }

    private String getUsage() {
        StringBuffer sbuf = new StringBuffer().append("Usage:\n");
        String pad1 = "   ";
        String pad = (pad1 + this.toolName_).replaceAll(".", " ");
        sbuf.append(pad1).append(this.toolName_).append(" [-help]").append(" [-version]").append(" [-verbose]").append(" [-disk]").append(" [-debug]").append(" [-prompt]").append(" [-batch]").append('\n').append(pad).append(" <task-name> <task-args>").append('\n').append('\n');
        sbuf.append(pad1).append(this.toolName_).append(" <task-name> help[=<param-name>]").append('\n').append('\n');
        sbuf.append("   Known tasks:\n");
        String[] tasks = this.taskFactory_.getNickNames();
        int i = 0;
        while (i < tasks.length) {
            sbuf.append("      ").append(tasks[i]).append('\n');
            ++i;
        }
        return sbuf.toString();
    }

    private static String getTaskUsage(Task task, String taskName) {
        String prefix = "Usage: " + taskName;
        StringBuffer usage = new StringBuffer();
        usage.append(LineInvoker.getPrefixedTaskUsage(task, prefix));
        String pad = prefix.replaceAll(".", " ");
        return usage.toString();
    }

    public static String getPrefixedTaskUsage(Task task, String prefix) {
        String word;
        Parameter[] params = task.getParameters();
        ArrayList namedWords = new ArrayList();
        ArrayList<String> numberedWords = new ArrayList<String>();
        int iPos = 0;
        int i = 0;
        while (i < params.length) {
            StringBuffer word2 = new StringBuffer();
            word2.append(' ');
            Parameter param = params[i];
            int pos = param.getPosition();
            boolean byPos = false;
            if (param.getPosition() > 0) {
                if (pos == ++iPos) {
                    byPos = true;
                } else {
                    logger_.warning("Parameter positions out of sync for " + param);
                }
            }
            if (byPos) {
                word2.append('[');
            }
            word2.append(param.getName()).append('=');
            if (byPos) {
                word2.append(']');
            }
            word2.append(param.getUsage());
            (byPos ? numberedWords : namedWords).add(word2.toString());
            ++i;
        }
        StringBuffer usage = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append(prefix);
        String pad = line.toString().replaceAll(".", " ");
        if (namedWords.size() > 0) {
            Iterator it = namedWords.iterator();
            while (it.hasNext()) {
                word = (String)it.next();
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        if (numberedWords.size() > 0) {
            Iterator it = numberedWords.iterator();
            while (it.hasNext()) {
                word = (String)it.next();
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        return usage.toString();
    }

    public static String getParamHelp(TableEnvironment env, String taskName, Parameter param) {
        boolean byPos = param.getPosition() > 0;
        boolean isOptional = param.getDefault() != null || param.isNullPermitted();
        StringBuffer sbuf = new StringBuffer();
        if (taskName != null) {
            sbuf.append("Help for parameter ").append(param.getName().toUpperCase()).append(" in task ").append(taskName.toUpperCase()).append('\n').append(sbuf.toString().replaceAll(".", "-"));
        }
        sbuf.append("\n   Name:\n").append("      ").append(param.getName()).append("\n\n   Usage:\n").append("      ").append(isOptional ? "[" : "").append(byPos ? "[" : "").append(param.getName()).append('=').append(byPos ? "]" : "").append(param.getUsage()).append(isOptional ? "]" : "").append("\n\n   Summary:\n").append("      ").append(param.getPrompt()).append("\n\n   Description:\n");
        try {
            sbuf.append(new Formatter().formatXML(param.getDescription()));
        }
        catch (SAXException e) {
            sbuf.append("      ???");
        }
        if (param.getDefault() != null || param.isNullPermitted()) {
            sbuf.append("\n\n   Default:\n").append("      ").append(param.getDefault());
        }
        if (param instanceof ExtraParameter) {
            sbuf.append("\n\n").append(((ExtraParameter)param).getExtraUsage(env));
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    private static String getUnusedWarning(String[] unused) {
        StringBuffer sbuf = new StringBuffer("Unused arguments:");
        int i = 0;
        while (i < unused.length) {
            sbuf.append(' ').append(unused[i]);
            ++i;
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    private static void configureLogging(int verbosity, boolean debug) {
        Logger rootLogger = Logger.getLogger("");
        int verbInt = Math.max(Level.ALL.intValue(), Level.WARNING.intValue() - verbosity * (Level.WARNING.intValue() - Level.INFO.intValue()));
        Level verbLevel = Level.parse(Integer.toString(verbInt));
        Handler[] rootHandlers = rootLogger.getHandlers();
        if (rootHandlers.length > 0 && rootHandlers[0] instanceof ConsoleHandler) {
            rootHandlers[0].setLevel(verbLevel);
            rootHandlers[0].setFormatter(new LineFormatter(debug));
        }
        rootLogger.setLevel(verbLevel);
        Logger.getLogger("org.apache.axis.utils.JavaUtils").setLevel(Level.SEVERE);
    }
}

