/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.LineEnvironment;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;

public class MapperTask
implements Task {
    private final TableMapper mapper_;
    private final int nIn_;
    private final InputTableParameter[] inTableParams_;
    private final FilterParameter[] inFilterParams_;
    private final FilterParameter outFilterParam_;
    private final TableConsumerParameter consumerParam_;
    private final Parameter[] params_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public MapperTask(TableMapper mapper, boolean useOutModes, boolean useInFilters, boolean useOutFilters) {
        int i;
        this.mapper_ = mapper;
        this.nIn_ = mapper.getInCount();
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        this.inTableParams_ = new InputTableParameter[this.nIn_];
        if (this.nIn_ == 1) {
            this.inTableParams_[0] = new InputTableParameter("in");
            this.inTableParams_[0].setUsage("<table>");
            this.inTableParams_[0].setPrompt("Location of input table");
            paramList.add(this.inTableParams_[0].getFormatParameter());
            paramList.add((Parameter)this.inTableParams_[0].getStreamParameter());
            paramList.add(this.inTableParams_[0]);
        } else {
            i = 0;
            while (i < this.nIn_) {
                InputTableParameter inParam;
                int i1 = i + 1;
                String ord = MapperTask.getOrdinal(i1);
                this.inTableParams_[i] = inParam = new InputTableParameter("in" + i1);
                inParam.setUsage("<table" + i1 + ">");
                inParam.setPrompt("Location of " + ord + " input table");
                inParam.setDescription(inParam.getDescription().replaceFirst("the input table", "the " + ord + " input table"));
                InputFormatParameter fmtParam = this.inTableParams_[i].getFormatParameter();
                fmtParam.setDescription(fmtParam.getDescription().replaceFirst("the input table", "the " + ord + " input table"));
                paramList.add(fmtParam);
                paramList.add(inParam);
                ++i;
            }
        }
        i = 0;
        while (i < this.nIn_) {
            this.inTableParams_[i].setPosition(i + 1);
            ++i;
        }
        if (useInFilters) {
            int i2;
            this.inFilterParams_ = new FilterParameter[this.nIn_];
            if (this.nIn_ == 1) {
                FilterParameter fp;
                this.inFilterParams_[0] = fp = new FilterParameter("icmd");
                fp.setPrompt("Processing command(s) for input table");
                fp.setDescription(new String[]{"Commands to operate on the input table,", "before any other processing takes place.", fp.getDescription()});
            } else {
                i2 = 0;
                while (i2 < this.nIn_) {
                    FilterParameter fp;
                    int i1 = i2 + 1;
                    this.inFilterParams_[i2] = fp = new FilterParameter("icmd" + i1);
                    fp.setPrompt("Processing command(s) for input table " + i1);
                    fp.setDescription(new String[]{"Commands to operate on the", MapperTask.getOrdinal(i1) + " input table, before any other", "processing takes place.", fp.getDescription()});
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.nIn_) {
                paramList.add(this.inFilterParams_[i2]);
                ++i2;
            }
        } else {
            this.inFilterParams_ = null;
        }
        MapperTask.addElements(paramList, mapper.getParameters());
        if (useOutFilters) {
            this.outFilterParam_ = new FilterParameter("ocmd");
            this.outFilterParam_.setPrompt("Processing command(s) for output table");
            this.outFilterParam_.setDescription(new String[]{"Commands to operate on the output table,", "after all other processing has taken place.", this.outFilterParam_.getDescription()});
            paramList.add(this.outFilterParam_);
        } else {
            this.outFilterParam_ = null;
        }
        if (useOutModes) {
            OutputModeParameter modeParam = new OutputModeParameter("omode");
            paramList.add(modeParam);
            MapperTask.addElements(paramList, this.getAssociatedParameters(modeParam));
            this.consumerParam_ = modeParam;
        } else {
            OutputTableParameter outParam = new OutputTableParameter("out");
            paramList.add(outParam);
            paramList.add(outParam.getFormatParameter());
            this.consumerParam_ = outParam;
        }
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public Parameter[] getParameters() {
        return this.params_;
    }

    private Parameter[] getAssociatedParameters(OutputModeParameter modeParam) {
        ProcessingMode mode;
        String modeName = modeParam.getDefault();
        try {
            mode = (ProcessingMode)Stilts.getModeFactory().createObject(modeName);
        }
        catch (LoadException e) {
            logger_.warning("Can't load default output mode?? " + e);
            return new Parameter[0];
        }
        Parameter[] modeParams = mode.getAssociatedParameters();
        if (modeParams.length != 2 || !(modeParams[0] instanceof OutputTableParameter) || !(modeParams[1] instanceof OutputFormatParameter)) {
            logger_.warning("Output mode parameters out of sync?");
        }
        OutputTableParameter outParam = new OutputTableParameter(modeParams[0].getName());
        OutputFormatParameter fmtParam = new OutputFormatParameter(modeParams[1].getName());
        Parameter[] resultParams = new Parameter[]{outParam, fmtParam};
        int i = 0;
        while (i < resultParams.length) {
            resultParams[i].setDescription(new String[]{resultParams[i].getDescription(), "This parameter must only be given if", "<code>" + modeParam.getName() + "</code>", "has its default value of \"<code>" + modeName + "</code>\"."});
            ++i;
        }
        return resultParams;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        final StarTable[] inTables = new StarTable[this.nIn_];
        int i = 0;
        while (i < this.nIn_) {
            inTables[i] = this.inTableParams_[i].tableValue(env);
            ++i;
        }
        final ProcessingStep[][] inSteps = new ProcessingStep[this.nIn_][];
        int i2 = 0;
        while (i2 < this.nIn_) {
            inSteps[i2] = this.inFilterParams_ != null ? this.inFilterParams_[i2].stepsValue(env) : new ProcessingStep[]{};
            ++i2;
        }
        final TableMapping mapping = this.mapper_.createMapping(env);
        final ProcessingStep[] outSteps = this.outFilterParam_ != null ? this.outFilterParam_.stepsValue(env) : new ProcessingStep[]{};
        final TableConsumer baseConsumer = this.consumerParam_.consumerValue(env);
        final TableConsumer consumer = new TableConsumer(){

            public void consume(StarTable table) throws IOException {
                int i = 0;
                while (i < outSteps.length) {
                    table = outSteps[i].wrap(table);
                    ++i;
                }
                baseConsumer.consume(table);
            }
        };
        this.checkUnused(env);
        return new Executable(){

            public void execute() throws IOException, TaskException {
                int i = 0;
                while (i < MapperTask.this.nIn_) {
                    int j = 0;
                    while (j < inSteps[i].length) {
                        inTables[i] = inSteps[i][j].wrap(inTables[i]);
                        ++j;
                    }
                    ++i;
                }
                mapping.mapTables(inTables, new TableConsumer[]{consumer});
            }
        };
    }

    private void checkUnused(Environment env) throws TaskException {
        if (env instanceof LineEnvironment) {
            String[] unused = ((LineEnvironment)env).getUnused();
            int i = 0;
            while (i < unused.length) {
                String word = unused[i];
                if (word.startsWith("out=") || word.startsWith("ofmt=")) {
                    throw new UsageException(word + ": out and ofmt parameters can only be used " + "when omode=out");
                }
                ++i;
            }
        }
    }

    private static void addElements(List list, Parameter[] params) {
        int i = 0;
        while (i < params.length) {
            list.add(params[i]);
            ++i;
        }
    }

    private static String getOrdinal(int i) {
        switch (i) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
        }
        return "next";
    }
}

