/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.table.join.TextProgressIndicator;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.JELTable;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.JoinTypeParameter;
import uk.ac.starlink.ttools.task.MatchEngineParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.WordsParameter;

public class Match2Mapper
implements TableMapper {
    private final MatchEngineParameter matcherParam_ = new MatchEngineParameter("matcher");
    private final WordsParameter[] tupleParams_ = new WordsParameter[2];
    private final JoinTypeParameter joinParam_;
    private final ChoiceParameter modeParam_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.ttools.task");

    public Match2Mapper() {
        int i = 0;
        while (i < 2) {
            int i1 = i + 1;
            this.tupleParams_[i] = new WordsParameter("values" + i1);
            this.tupleParams_[i].setUsage("<expr-list>");
            this.tupleParams_[i].setPrompt("Expressions for match values from table " + i1);
            this.tupleParams_[i].setDescription(new String[]{"Defines the values from table " + i1, "which are used to determine whether a match has occurred.", "These will typically be coordinate values such as RA and Dec", "and perhaps some per-row error values as well, though exactly", "what values are required is determined by the kind of match", "as determined by", "<code>" + this.matcherParam_.getName() + "</code>.", "Depending on the kind of match, the number and type of", "the values required will be different.", "Multiple values should be separated by whitespace;", "if whitespace occurs within a single value it must be", "'quoted' or \"quoted\".", "Elements of the expression list are commonly just column", "names, but may be algebraic expressions calculated from", "zero or more columns as explained in <ref id='jel'/>."});
            ++i;
        }
        this.modeParam_ = new ChoiceParameter("find", new String[]{"best", "all"});
        this.modeParam_.setDefault("best");
        this.modeParam_.setPrompt("Type of match to perform");
        this.modeParam_.setDescription(new String[]{"Determines which matches are retained.", "If <code>best</code> is selected, then only the best match", "between the two tables will be retained; in this case", "the data from a row of either input table will appear in", "at most one row of the output table.", "If <code>all</code> is selected, then all pairs of rows", "from the two input tables which match the input criteria", "will be represented in the output table."});
        this.joinParam_ = new JoinTypeParameter("join");
        this.joinParam_.setDefault("1and2");
        this.joinParam_.setPrompt("Selection criteria for output rows");
    }

    public int getInCount() {
        return 2;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.matcherParam_, this.tupleParams_[0], this.tupleParams_[1], this.matcherParam_.getMatchParametersParameter(), this.joinParam_, this.modeParam_};
    }

    public TableMapping createMapping(Environment env) throws TaskException {
        boolean bestOnly;
        MatchEngine matcher = this.matcherParam_.matchEngineValue(env);
        ValueInfo[] tinfos = matcher.getTupleInfos();
        int ncol = tinfos.length;
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < ncol) {
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append(tinfos[i].getName());
            ++i;
        }
        String colNames = sbuf.toString();
        String[][] tupleExprs = new String[2][];
        int i2 = 0;
        while (i2 < 2) {
            int i1 = i2 + 1;
            this.tupleParams_[i2].setRequiredWordCount(ncol);
            this.tupleParams_[i2].setPrompt("Table " + i1 + " match columns (" + colNames + ")");
            tupleExprs[i2] = this.tupleParams_[i2].wordsValue(env);
            ++i2;
        }
        JoinType join = this.joinParam_.joinTypeValue(env);
        String mode = this.modeParam_.stringValue(env);
        if (mode.toLowerCase().equals("best")) {
            bestOnly = true;
        } else if (mode.toLowerCase().equals("all")) {
            bestOnly = false;
        } else {
            throw new UsageException("Unknown value of " + this.modeParam_.getName() + "??");
        }
        PrintStream logStrm = env.getErrorStream();
        return new Match2Mapping(matcher, tupleExprs[0], tupleExprs[1], join, bestOnly, logStrm);
    }

    private static class Match2Mapping
    implements TableMapping {
        final String[][] exprTuples_;
        final MatchEngine matchEngine_;
        final boolean bestOnly_;
        final JoinType join_;
        final PrintStream logStrm_;

        Match2Mapping(MatchEngine matchEngine, String[] exprTuple1, String[] exprTuple2, JoinType join, boolean bestOnly, PrintStream logStrm) {
            this.matchEngine_ = matchEngine;
            this.exprTuples_ = new String[][]{exprTuple1, exprTuple2};
            this.join_ = join;
            this.bestOnly_ = bestOnly;
            this.logStrm_ = logStrm;
        }

        public void mapTables(StarTable[] inTables, TableConsumer[] consumers) throws IOException, TaskException {
            LinkSet matches;
            this.makeSubTables(inTables);
            int i = 0;
            while (i < 2) {
                inTables[i] = Tables.randomTable(inTables[i]);
                ++i;
            }
            StarTable[] subTables = this.makeSubTables(inTables);
            RowMatcher matcher = new RowMatcher(this.matchEngine_, subTables);
            matcher.setIndicator(new TextProgressIndicator(this.logStrm_));
            try {
                matches = matcher.findPairMatches(this.bestOnly_);
                if (!matches.sort()) {
                    logger.warning("Implementation can't sort rows - matched table rows may not be ordered");
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            JoinFixAction[] fixActs = new JoinFixAction[]{JoinFixAction.makeRenameDuplicatesAction("_1"), JoinFixAction.makeRenameDuplicatesAction("_2")};
            ValueInfo scoreInfo = this.matchEngine_.getMatchScoreInfo();
            StarTable out = MatchStarTables.makeJoinTable(inTables[0], inTables[1], matches, this.join_, !this.bestOnly_, fixActs, scoreInfo);
            consumers[0].consume(out);
        }

        private StarTable[] makeSubTables(StarTable[] inTables) throws ExecutionException {
            ValueInfo[] tupleInfos = this.matchEngine_.getTupleInfos();
            int nCoord = tupleInfos.length;
            StarTable[] subTables = new StarTable[inTables.length];
            int i = 0;
            while (i < subTables.length) {
                ColumnInfo[] colInfos = new ColumnInfo[nCoord];
                int j = 0;
                while (j < nCoord) {
                    colInfos[j] = new ColumnInfo(tupleInfos[j]);
                    ++j;
                }
                try {
                    subTables[i] = new JELTable(inTables[i], colInfos, this.exprTuples_[i]);
                }
                catch (CompilationException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            return subTables;
        }
    }
}

