/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.logging.Logger;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AnisotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.CombinedMatchEngine;
import uk.ac.starlink.table.join.EqualsMatchEngine;
import uk.ac.starlink.table.join.HEALPixMatchEngine;
import uk.ac.starlink.table.join.HTMMatchEngine;
import uk.ac.starlink.table.join.IsotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.SphericalPolarMatchEngine;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.HumanMatchEngine;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.task.WordsParameter;

public class MatchEngineParameter
extends Parameter
implements ExtraParameter {
    private final WordsParameter paramsParam_ = new WordsParameter("params");
    private MatchEngine matchEngine_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    private static final String[] EXAMPLES = new String[]{"sky", "skyerr", "sky3d", "exact", "1d", "2d", "3d", "2d_anisotropic", "3d_anisotropic", "sky+1d"};

    public MatchEngineParameter(String name) {
        super(name);
        this.setDefault("sky");
        this.setPreferExplicit(true);
        this.setUsage("<matcher-name>");
        this.setPrompt("Name of matching algorithm");
        this.setDescription(new String[]{"Defines the nature of the matching that will be performed.", "Depending on the name supplied, this may be positional", "matching using celestial or Cartesian coordinates,", "exact matching on the value of a string column,", "or other things.", "A list and explanation of the available matching algorithms", "is given in <ref id='MatchEngine'/>.", "The value supplied for this parameter determines the meanings", "of the values required by the ", "<code>" + this.paramsParam_.getName() + "</code>,", "<code>values1</code> and <code>values2</code> parameters."});
        this.paramsParam_.setPrompt("Match parameters");
        this.paramsParam_.setDescription(new String[]{"Determines the parameters of this match.", "This is typically one or more tolerances such as error radii.", "It may contain zero or more values; the values that are", "required depend on the match type selected by the", "<code>" + this.getName() + "</code> parameter.", "If it contains multiple values, they must be separated by spaces;", "values which contain a space can be 'quoted' or \"quoted\"."});
        this.paramsParam_.setUsage("<match-params>");
    }

    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Available matchers, with associated parameters, include:\n");
        try {
            int i = 0;
            while (i < EXAMPLES.length) {
                StringBuffer line = new StringBuffer();
                String name = EXAMPLES[i];
                MatchEngine engine = this.createEngine(name);
                line.append("      ").append(this.getName()).append('=').append(name);
                String pad = line.toString().replaceAll(".", " ");
                String vu = this.getValuesUsage(engine);
                String pu = this.getParamsUsage(engine);
                line.append(vu);
                if (line.length() + pu.length() > 78) {
                    line.append('\n').append(pad);
                }
                line.append(pu).append('\n');
                sbuf.append(line);
                ++i;
            }
        }
        catch (UsageException e) {
            sbuf.append("\n      ???\n");
        }
        return sbuf.toString();
    }

    public Parameter getMatchParametersParameter() {
        return this.paramsParam_;
    }

    public MatchEngine matchEngineValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.matchEngine_;
    }

    public void setValueFromString(Environment env, String stringVal) throws TaskException {
        String name = stringVal.toLowerCase();
        MatchEngine engine = this.createEngine(name);
        DescribedValue[] params = engine.getMatchParameters();
        int nParam = params.length;
        if (nParam == 0) {
            this.paramsParam_.setNullPermitted(true);
            this.paramsParam_.setDefault(null);
        } else {
            StringBuffer sbuf = new StringBuffer("Match parameters (");
            int i = 0;
            while (i < nParam) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(this.getInfoUsage(params[i].getInfo()));
                ++i;
            }
            sbuf.append(')');
            this.paramsParam_.setPrompt(sbuf.toString());
            this.paramsParam_.setRequiredWordCount(nParam);
            String[] words = this.paramsParam_.wordsValue(env);
            int i2 = 0;
            while (i2 < nParam) {
                String word = words[i2];
                try {
                    params[i2].setValueFromString(word);
                    logger_.info(params[i2].toString());
                }
                catch (IllegalArgumentException e) {
                    throw new UsageException("Value " + words[i2] + " not suitable " + "for matching parameter " + params[i2].getInfo());
                }
                ++i2;
            }
        }
        this.matchEngine_ = engine;
    }

    public MatchEngine createEngine(String name) throws UsageException {
        String[] names = name.trim().toLowerCase().split("\\+");
        MatchEngine[] components = new MatchEngine[names.length];
        int i = 0;
        while (i < names.length) {
            int ndim;
            MatchEngine component;
            String cName = names[i];
            if ("sky".equals(cName) || "healpix".equals(cName)) {
                component = new HEALPixMatchEngine(4.84813681109536E-6, false);
            } else if ("skyerr".equals(cName)) {
                component = new HEALPixMatchEngine(4.84813681109536E-6, true);
            } else if ("sky3d".equals(cName)) {
                component = new SphericalPolarMatchEngine(0.0);
            } else if ("exact".equals(cName)) {
                component = new EqualsMatchEngine();
            } else if (cName.matches("[0-9]d")) {
                ndim = Integer.parseInt(cName.substring(0, 1));
                component = new IsotropicCartesianMatchEngine(ndim, 0.0, false);
            } else if (cName.matches("[0-9]d_anisotropic")) {
                ndim = Integer.parseInt(cName.substring(0, 1));
                component = new AnisotropicCartesianMatchEngine(new double[ndim]);
            } else if (cName.matches("htm")) {
                component = new HTMMatchEngine(4.84813681109536E-6, false);
            } else {
                throw new UsageException("Unknown matcher element: " + cName);
            }
            components[i] = new HumanMatchEngine(component);
            ++i;
        }
        return components.length == 1 ? components[0] : new CombinedMatchEngine(components);
    }

    public String getValuesUsage(MatchEngine engine) {
        StringBuffer sbuf = new StringBuffer();
        ValueInfo[] tupleInfos = engine.getTupleInfos();
        if (tupleInfos.length > 0) {
            sbuf.append(" values*='");
            int i = 0;
            while (i < tupleInfos.length) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('<').append(this.getInfoUsage(tupleInfos[i])).append('>');
                ++i;
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    public String getParamsUsage(MatchEngine engine) {
        StringBuffer sbuf = new StringBuffer();
        DescribedValue[] params = engine.getMatchParameters();
        if (params.length > 0) {
            sbuf.append(" params='");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('<').append(this.getInfoUsage(params[i].getInfo())).append('>');
                ++i;
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    private String getInfoUsage(ValueInfo info) {
        StringBuffer sbuf = new StringBuffer().append(info.getName().toLowerCase().replaceAll(" ", "-"));
        String units = info.getUnitString();
        if (units != null) {
            sbuf.append('/').append(units);
        }
        return sbuf.toString();
    }
}

