/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.Iterator;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class OutputFormatParameter
extends Parameter
implements ExtraParameter {
    public OutputFormatParameter(String name) {
        super(name);
        this.setUsage("<out-format>");
        this.setPrompt("Format name for output table");
        this.setDefault("(auto)");
        this.setNullPermitted(false);
        this.setDescription(new String[]{"Specifies the format in which the output table will be written", "(one of the ones in <ref id='outFormats'/> - matching is", "case-insensitive and you can use just the first few letters).", "If it has the special value", "\"<code>(auto)</code>\"", "(the default),", "then the output filename will be", "examined to try to guess what sort of file is required", "usually by looking at the extension.", "If it's not obvious from the filename what output format is", "intended, an error will result."});
    }

    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Known output formats:\n");
        sbuf.append("      ").append("(auto)").append('\n');
        Iterator it = env.getTableOutput().getKnownFormats().iterator();
        while (it.hasNext()) {
            sbuf.append("      ").append(((String)it.next()).toLowerCase()).append('\n');
        }
        return sbuf.toString();
    }
}

