/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.ObjectFactory;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class OutputModeParameter
extends Parameter
implements TableConsumerParameter,
ExtraParameter {
    private ProcessingMode mode_;
    private TableConsumer consumer_;

    public OutputModeParameter(String name) {
        super(name);
        this.setPrompt("Output mode");
        this.setDefault("out");
        this.setUsage("<out-mode> <mode-args>");
        StringBuffer sbuf = new StringBuffer();
        String[] modeNames = Stilts.getModeFactory().getNickNames();
        int i = 0;
        while (i < modeNames.length) {
            sbuf.append(" <code>").append(modeNames[i]).append("</code>");
            switch (modeNames.length - 1 - i) {
                case 0: {
                    break;
                }
                case 1: {
                    sbuf.append(" and");
                    break;
                }
                default: {
                    sbuf.append(',');
                }
            }
            ++i;
        }
        String modeList = sbuf.toString();
        this.setDescription(new String[]{"The mode in which the result table will be output.", "The default mode is <code>out</code>, which means that", "the result will be written as a new table to disk or elsewhere,", "as determined by the <code>out</code> and <code>ofmt</code>", "parameters.", "However, there are other possibilities, which correspond", "to uses to which a table can be put other than outputting it,", "such as displaying metadata, calculating statistics,", "or populating a table in an SQL database.", "For some values of this parameter, additional parameters", "(<code>&lt;mode-args&gt;</code>)", "are required to determine the exact behaviour.", "Possible values are" + modeList + ".", "Use the <code>help=" + this.getName() + "</code> flag", "or see <ref id=\"outModes\"/> for more information."});
    }

    public String getExtraUsage(TableEnvironment env) {
        ObjectFactory modeFactory = Stilts.getModeFactory();
        String[] names = modeFactory.getNickNames();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Available modes, with associated arguments:\n");
        int i = 0;
        while (i < names.length) {
            block5: {
                String name = names[i];
                try {
                    ProcessingMode mode = (ProcessingMode)modeFactory.createObject(name);
                    StringBuffer line = new StringBuffer().append("      ").append(this.getName()).append('=').append(name);
                    String pad = line.toString().replaceAll(".", " ");
                    Parameter[] params = mode.getAssociatedParameters();
                    int j = 0;
                    while (j < params.length) {
                        Parameter param = params[j];
                        String word = " " + param.getName() + "=" + param.getUsage();
                        if (line.length() + word.length() > 78) {
                            sbuf.append(line).append('\n');
                            line = new StringBuffer(pad);
                        }
                        line.append(word);
                        ++j;
                    }
                    sbuf.append(line).append('\n');
                }
                catch (LoadException e) {
                    if (!env.isDebug()) break block5;
                    sbuf.append("    ( ").append("mode=").append(name).append(" - not available: ").append(e).append(" )").append('\n');
                }
            }
            ++i;
        }
        sbuf.append('\n').append(new OutputFormatParameter("ofmt").getExtraUsage(env));
        return sbuf.toString();
    }

    public void setValueFromString(Environment env, String stringval) throws TaskException {
        ObjectFactory modeFactory = Stilts.getModeFactory();
        if (!modeFactory.isRegistered(stringval)) {
            throw new ParameterValueException((Parameter)this, "No such mode: " + stringval);
        }
        try {
            ProcessingMode mode = (ProcessingMode)modeFactory.createObject(stringval);
            this.consumer_ = mode.createConsumer(env);
            this.mode_ = mode;
        }
        catch (LoadException e) {
            throw new ParameterValueException((Parameter)this, "Mode " + stringval + " unavailable - " + e, (Throwable)e);
        }
        super.setValueFromString(env, stringval);
    }

    public TableConsumer consumerValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.consumer_;
    }

    public void setValueFromConsumer(TableConsumer consumer) {
        this.consumer_ = consumer;
        this.setGotValue(true);
    }
}

