/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.FilterScriptParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;

public class PipeMapper
implements TableMapper {
    private final InputStreamParameter scriptParam_ = new FilterScriptParameter("script");
    private final FilterParameter stepParam_;

    public PipeMapper() {
        this.scriptParam_.setUsage("<script-file>");
        this.scriptParam_.setNullPermitted(true);
        this.scriptParam_.setPrompt("File containing table filter commands");
        this.stepParam_ = new FilterParameter("cmd");
        this.stepParam_.setNullPermitted(true);
        this.stepParam_.setPrompt("Command describing a table processing step");
        this.scriptParam_.setDescription(new String[]{"Location of a file containing table processing commands.", "Each line of this file contains one of the filter commands", "described in <ref id=\"filterSteps\"/>.", "The sequence of commands given by the lines of this file", "defines the processing pipeline which is performed on the table.", "The", "<code>" + this.scriptParam_.getName() + "</code> and", "<code>" + this.stepParam_.getName() + "</code>", "flags should not be mixed in the same invocation."});
        this.stepParam_.setDescription(new String[]{"Text of table processing commands.", this.stepParam_.getDescription(), "The", "<code>" + this.scriptParam_.getName() + "</code> and", "<code>" + this.stepParam_.getName() + "</code>", "flags should not be mixed in the same invocation."});
    }

    public int getInCount() {
        return 1;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.scriptParam_, this.stepParam_};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMapping createMapping(Environment env) throws TaskException {
        ProcessingStep[] steps;
        block5: {
            try {
                InputStream in = this.scriptParam_.inputStreamValue(env);
                if (in != null) {
                    try {
                        steps = PipeMapper.readSteps(in);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    {
                        break block5;
                    }
                }
                steps = this.stepParam_.stepsValue(env);
            }
            catch (IOException e) {
                throw new UsageException(e.getMessage(), (Throwable)e);
            }
        }
        return new PipeMapping(steps);
    }

    /*
     * WARNING - void declaration
     */
    private static ProcessingStep[] readSteps(InputStream istrm) throws TaskException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(istrm));
            ArrayList<ProcessingStep> stepList = new ArrayList<ProcessingStep>();
            while ((line = in.readLine()) != null) {
                void var3_4;
                ProcessingStep step = StepFactory.getInstance().createStep((String)var3_4);
                if (step == null) continue;
                stepList.add(step);
            }
            return stepList.toArray(new ProcessingStep[0]);
        }
        catch (IOException e) {
            throw new ExecutionException("Error reading script", (Throwable)e);
        }
    }

    private static class PipeMapping
    implements TableMapping {
        final ProcessingStep[] steps_;

        PipeMapping(ProcessingStep[] steps) {
            this.steps_ = steps;
        }

        public void mapTables(StarTable[] in, TableConsumer[] out) throws IOException {
            if (in.length != 1 || out.length != 1) {
                throw new IllegalArgumentException();
            }
            StarTable table = in[0];
            int i = 0;
            while (i < this.steps_.length) {
                table = this.steps_[i].wrap(table);
                ++i;
            }
            out[0].consume(table);
        }
    }
}

