/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;

public class TableCopy
implements Task {
    private final InputTableParameter inParam_ = new InputTableParameter("in");
    private final InputFormatParameter ifmtParam_;
    private final OutputTableParameter outParam_;
    private final OutputFormatParameter ofmtParam_;

    public TableCopy() {
        this.inParam_.setPrompt("Location of input table");
        this.inParam_.setPosition(1);
        this.outParam_ = new OutputTableParameter("out");
        this.outParam_.setPosition(2);
        this.ifmtParam_ = this.inParam_.getFormatParameter();
        this.ifmtParam_.setPrompt("Format of input table");
        this.ifmtParam_.setName("ifmt");
        this.ofmtParam_ = this.outParam_.getFormatParameter();
        this.ofmtParam_.setPrompt("Format of output table");
        this.ofmtParam_.setName("ofmt");
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inParam_, this.outParam_, this.ifmtParam_, this.ofmtParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        final StarTable inTable = this.inParam_.tableValue(env);
        final TableConsumer consumer = this.outParam_.consumerValue(env);
        return new Executable(){

            public void execute() throws IOException {
                consumer.consume(inTable);
            }
        };
    }
}

