/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.votable.VOElementFactory;

public abstract class TableEnvironment
implements Environment {
    private StarTableFactory tfact_;
    private StarTableOutput tout_;
    private JDBCAuthenticator jdbcAuth_;
    private boolean debug_;
    private Boolean isStrict_;

    public StarTableFactory getTableFactory() {
        if (this.tfact_ == null) {
            this.tfact_ = new StarTableFactory();
        }
        return this.tfact_;
    }

    public StarTableOutput getTableOutput() {
        if (this.tout_ == null) {
            this.tout_ = new StarTableOutput();
        }
        return this.tout_;
    }

    public JDBCAuthenticator getJdbcAuthenticator() {
        if (this.jdbcAuth_ == null) {
            this.jdbcAuth_ = new TerminalAuthenticator(this.getErrorStream());
        }
        return this.jdbcAuth_;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean isStrictVotable() {
        return this.isStrict_ == null ? VOElementFactory.isStrictByDefault() : this.isStrict_;
    }

    public void setStrictVotable(boolean strict) {
        this.isStrict_ = strict ? Boolean.TRUE : Boolean.FALSE;
    }

    public static StarTableFactory getTableFactory(Environment env) {
        return env instanceof TableEnvironment ? ((TableEnvironment)env).getTableFactory() : new StarTableFactory();
    }

    public static StarTableOutput getTableOutput(Environment env) {
        return env instanceof TableEnvironment ? ((TableEnvironment)env).getTableOutput() : new StarTableOutput();
    }

    public static JDBCAuthenticator getJdbcAuthenticator(Environment env) {
        return env instanceof TableEnvironment ? ((TableEnvironment)env).getJdbcAuthenticator() : new TerminalAuthenticator();
    }

    public static StoragePolicy getStoragePolicy(Environment env) {
        return TableEnvironment.getTableFactory(env).getStoragePolicy();
    }

    public static boolean isStrictVotable(Environment env) {
        return env instanceof TableEnvironment ? ((TableEnvironment)env).isStrictVotable() : VOElementFactory.isStrictByDefault();
    }
}

