/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.votable.DataFormat;

public class VotFormatParameter
extends Parameter {
    private static DataFormat[] VOT_FORMATS = new DataFormat[]{DataFormat.TABLEDATA, DataFormat.BINARY, DataFormat.FITS};
    private DataFormat dataFormat_;

    public VotFormatParameter(String name) {
        super(name);
        StringBuffer usage = new StringBuffer();
        int i = 0;
        while (i < VOT_FORMATS.length) {
            usage.append(VOT_FORMATS[i].toString().toLowerCase()).append('|');
            ++i;
        }
        usage.append("empty");
        this.setUsage(usage.toString());
        this.setDefault(DataFormat.TABLEDATA.toString().toLowerCase());
        this.setDescription(new String[]{"Determines the encoding format of the table data in the ", "output document.", "If <code>empty</code> is selected, then the tables will be", "data-less (will contain no DATA element), leaving only", "the document structure.", "Data-less tables are legal VOTable elements."});
    }

    public DataFormat formatValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.dataFormat_;
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        int i = 0;
        while (i < VOT_FORMATS.length) {
            DataFormat format = VOT_FORMATS[i];
            if (format.toString().equalsIgnoreCase(sval)) {
                this.dataFormat_ = format;
                super.setValueFromString(env, sval);
                return;
            }
            ++i;
        }
        if (sval == null || sval.equalsIgnoreCase("empty")) {
            this.dataFormat_ = null;
            super.setValueFromString(env, sval);
            return;
        }
        throw new ParameterValueException((Parameter)this, "Unknown format " + sval);
    }
}

