/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Tokenizer;

public class WordsParameter
extends Parameter {
    private int nWords_ = -1;

    public WordsParameter(String name) {
        super(name);
    }

    public void setRequiredWordCount(int nWords) {
        this.nWords_ = nWords;
    }

    public int getRequiredWordCount() {
        return this.nWords_;
    }

    public String[] wordsValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        String sval = this.stringValue(env);
        String[] words = Tokenizer.tokenizeWords(sval);
        if (this.nWords_ >= 0 && this.nWords_ != words.length) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("Wrong number of words in parameter ").append(this.getName()).append(" - wanted ").append(this.nWords_).append(", got ").append(words.length).append('\n').append("Value was: ").append(sval).append('\n').append("Words containing spaces must be 'quoted' ").append("or \"quoted\"\n");
            throw new UsageException(sbuf.toString());
        }
        return words;
    }
}

