/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.XmlChan;

public class Channel
extends AstObject {
    private long chaninfo;
    private BufferedReader inreader;
    private OutputStream outstream;

    public Channel(InputStream in, OutputStream out) {
        if (in == null) {
            in = System.in;
        }
        if (out == null) {
            out = System.out;
        }
        this.inreader = new BufferedReader(new InputStreamReader(in));
        this.outstream = out;
        this.construct();
    }

    protected Channel() {
        this.construct();
    }

    protected Channel(Channel dummy) {
    }

    public void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    protected String source() throws IOException {
        return this.inreader.readLine();
    }

    protected void sink(String line) throws IOException {
        this.outstream.write(line.getBytes());
        this.outstream.write(10);
    }

    private void construct() {
        if (this instanceof XmlChan) {
            this.constructXmlChan();
        } else {
            this.constructChannel();
        }
    }

    private native void constructChannel();

    private native void constructXmlChan();

    private native void destroy();

    public native AstObject read() throws IOException;

    public native void write(AstObject var1) throws IOException;

    public boolean getComment() {
        return this.getB("Comment");
    }

    public void setComment(boolean comment) {
        this.setB("Comment", comment);
    }

    public int getFull() {
        return this.getI("Full");
    }

    public void setFull(int full) {
        this.setI("Full", full);
    }

    public boolean getSkip() {
        return this.getB("Skip");
    }

    public void setSkip(boolean skip) {
        this.setB("Skip", skip);
    }

    public AstObject copy() {
        throw new UnsupportedOperationException("Sorry - copy not currently supported for Channels");
    }

    public Object clone() {
        throw new UnsupportedOperationException("Sorry - clone not currently supported for Channels");
    }
}

