/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.UinterpCalculator;
import uk.ac.starlink.ast.Ukern1Calculator;

public class Mapping
extends AstObject {
    public static final Interpolator NEAREST_INTERPOLATOR = Interpolator.nearest();
    public static final Interpolator LINEAR_INTERPOLATOR = Interpolator.linear();
    public static final Spreader NEAREST_SPREADER = Spreader.nearest();
    public static final Spreader LINEAR_SPREADER = Spreader.linear();

    protected Mapping() {
    }

    public void invert() {
        this.setInvert(!this.getInvert());
    }

    public native Mapping simplify();

    public native Mapping[] decompose(boolean[] var1, boolean[] var2);

    public native double[] mapBox(double[] var1, double[] var2, boolean var3, int var4, double[] var5, double[] var6);

    public int resample(int ndim_in, int[] lbnd_in, int[] ubnd_in, Object in, Object in_var, Interpolator interp, boolean usebad, double tol, int maxpix, Number badval, int ndim_out, int[] lbnd_out, int[] ubnd_out, int[] lbnd, int[] ubnd, Object out, Object out_var) {
        Class<?> type = in.getClass().getComponentType();
        try {
            if (type == Byte.TYPE) {
                return this.resampleB(ndim_in, lbnd_in, ubnd_in, (byte[])in, (byte[])in_var, interp, usebad, tol, maxpix, (Byte)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (byte[])out, (byte[])out_var);
            }
            if (type == Short.TYPE) {
                return this.resampleS(ndim_in, lbnd_in, ubnd_in, (short[])in, (short[])in_var, interp, usebad, tol, maxpix, (Short)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (short[])out, (short[])out_var);
            }
            if (type == Integer.TYPE) {
                return this.resampleI(ndim_in, lbnd_in, ubnd_in, (int[])in, (int[])in_var, interp, usebad, tol, maxpix, (Integer)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (int[])out, (int[])out_var);
            }
            if (type == Long.TYPE) {
                return this.resampleL(ndim_in, lbnd_in, ubnd_in, (long[])in, (long[])in_var, interp, usebad, tol, maxpix, (Long)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (long[])out, (long[])out_var);
            }
            if (type == Float.TYPE) {
                return this.resampleF(ndim_in, lbnd_in, ubnd_in, (float[])in, (float[])in_var, interp, usebad, tol, maxpix, ((Float)badval).floatValue(), ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (float[])out, (float[])out_var);
            }
            if (type == Double.TYPE) {
                return this.resampleD(ndim_in, lbnd_in, ubnd_in, (double[])in, (double[])in_var, interp, usebad, tol, maxpix, (Double)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (double[])out, (double[])out_var);
            }
            throw new ClassCastException("dummy ClassCastException");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("in, in_var, out, out_var must be all arrays of the same primitive type, and badval a matching Number type");
        }
    }

    public native int resampleB(int var1, int[] var2, int[] var3, byte[] var4, byte[] var5, Interpolator var6, boolean var7, double var8, int var10, byte var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16, byte[] var17, byte[] var18);

    public native int resampleS(int var1, int[] var2, int[] var3, short[] var4, short[] var5, Interpolator var6, boolean var7, double var8, int var10, short var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16, short[] var17, short[] var18);

    public native int resampleI(int var1, int[] var2, int[] var3, int[] var4, int[] var5, Interpolator var6, boolean var7, double var8, int var10, int var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16, int[] var17, int[] var18);

    public native int resampleL(int var1, int[] var2, int[] var3, long[] var4, long[] var5, Interpolator var6, boolean var7, double var8, int var10, long var11, int var13, int[] var14, int[] var15, int[] var16, int[] var17, long[] var18, long[] var19);

    public native int resampleF(int var1, int[] var2, int[] var3, float[] var4, float[] var5, Interpolator var6, boolean var7, double var8, int var10, float var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16, float[] var17, float[] var18);

    public native int resampleD(int var1, int[] var2, int[] var3, double[] var4, double[] var5, Interpolator var6, boolean var7, double var8, int var10, double var11, int var13, int[] var14, int[] var15, int[] var16, int[] var17, double[] var18, double[] var19);

    public void rebin(double wlim, int ndim_in, int[] lbnd_in, int[] ubnd_in, Object in, Object in_var, Spreader spread, boolean usebad, double tol, int maxpix, Number badval, int ndim_out, int[] lbnd_out, int[] ubnd_out, int[] lbnd, int[] ubnd, Object out, Object out_var) {
        block5: {
            Class<?> type = in.getClass().getComponentType();
            try {
                if (type == Integer.TYPE) {
                    this.rebinI(wlim, ndim_in, lbnd_in, ubnd_in, (int[])in, (int[])in_var, spread, usebad, tol, maxpix, (Integer)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (int[])out, (int[])out_var);
                    break block5;
                }
                if (type == Float.TYPE) {
                    this.rebinF(wlim, ndim_in, lbnd_in, ubnd_in, (float[])in, (float[])in_var, spread, usebad, tol, maxpix, ((Float)badval).floatValue(), ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (float[])out, (float[])out_var);
                    break block5;
                }
                if (type == Double.TYPE) {
                    this.rebinD(wlim, ndim_in, lbnd_in, ubnd_in, (double[])in, (double[])in_var, spread, usebad, tol, maxpix, (Double)badval, ndim_out, lbnd_out, ubnd_out, lbnd, ubnd, (double[])out, (double[])out_var);
                    break block5;
                }
                throw new ClassCastException("Dummy class cast exception");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("in, in_var, out and out_var must all be arrays of the same primitive type, and badval a matching Number type");
            }
        }
    }

    public native void rebinI(double var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, Spreader var8, boolean var9, double var10, int var12, int var13, int var14, int[] var15, int[] var16, int[] var17, int[] var18, int[] var19, int[] var20);

    public native void rebinF(double var1, int var3, int[] var4, int[] var5, float[] var6, float[] var7, Spreader var8, boolean var9, double var10, int var12, float var13, int var14, int[] var15, int[] var16, int[] var17, int[] var18, float[] var19, float[] var20);

    public native void rebinD(double var1, int var3, int[] var4, int[] var5, double[] var6, double[] var7, Spreader var8, boolean var9, double var10, int var12, double var13, int var15, int[] var16, int[] var17, int[] var18, int[] var19, double[] var20, double[] var21);

    public native double[] tran1(int var1, double[] var2, boolean var3);

    public native double[][] tran2(int var1, double[] var2, double[] var3, boolean var4);

    public native double[] tranN(int var1, int var2, double[] var3, boolean var4, int var5);

    public native double[][] tranP(int var1, int var2, double[][] var3, boolean var4, int var5);

    public native double rate(double[] var1, int var2, int var3);

    public native double[] linearApprox(double[] var1, double[] var2, double var3);

    public boolean getInvert() {
        return this.getB("Invert");
    }

    public void setInvert(boolean invert) {
        this.setB("Invert", invert);
    }

    public int getNin() {
        return this.getI("Nin");
    }

    public int getNout() {
        return this.getI("Nout");
    }

    public boolean getReport() {
        return this.getB("Report");
    }

    public void setReport(boolean report) {
        this.setB("Report", report);
    }

    public boolean getTranForward() {
        return this.getB("TranForward");
    }

    public boolean getTranInverse() {
        return this.getB("TranInverse");
    }

    public static class Spreader {
        private int scheme_;
        private double[] params_;
        private static final int AST__NEAREST = AstObject.getAstConstantI("AST__NEAREST");
        private static final int AST__LINEAR = AstObject.getAstConstantI("AST__LINEAR");
        private static final int AST__SINC = AstObject.getAstConstantI("AST__SINC");
        private static final int AST__SINCSINC = AstObject.getAstConstantI("AST__SINCSINC");
        private static final int AST__SINCCOS = AstObject.getAstConstantI("AST__SINCCOS");
        private static final int AST__SINCGAUSS = AstObject.getAstConstantI("AST__SINCGAUSS");
        private static final int AST__GAUSS = AstObject.getAstConstantI("AST__GAUSS");

        private Spreader(int scheme, double[] params) {
            this.scheme_ = scheme;
            this.params_ = params;
        }

        public static Spreader nearest() {
            return new Spreader(AST__NEAREST, null);
        }

        public static Spreader linear() {
            return new Spreader(AST__LINEAR, null);
        }

        public static Spreader sinc(int npix) {
            return new Spreader(AST__SINC, new double[]{npix});
        }

        public static Spreader sincSinc(int npix, double width) {
            return new Spreader(AST__SINCSINC, new double[]{npix, width});
        }

        public static Spreader sincCos(int npix, double width) {
            return new Spreader(AST__SINCCOS, new double[]{npix, width});
        }

        public static Spreader sincGauss(int npix, double fwhm) {
            return new Spreader(AST__SINCGAUSS, new double[]{npix, fwhm});
        }

        public static Spreader gauss(int npix, double fwhm) {
            return new Spreader(AST__GAUSS, new double[]{npix, fwhm});
        }
    }

    public static class Interpolator {
        private int scheme;
        private Ukern1Calculator ukern1er;
        private UinterpCalculator uinterper;
        private double[] params;
        private static final int AST__NEAREST = AstObject.getAstConstantI("AST__NEAREST");
        private static final int AST__LINEAR = AstObject.getAstConstantI("AST__LINEAR");
        private static final int AST__SINC = AstObject.getAstConstantI("AST__SINC");
        private static final int AST__SINCSINC = AstObject.getAstConstantI("AST__SINCSINC");
        private static final int AST__SINCCOS = AstObject.getAstConstantI("AST__SINCCOS");
        private static final int AST__SINCGAUSS = AstObject.getAstConstantI("AST__SINCGAUSS");
        private static final int AST__BLOCKAVE = AstObject.getAstConstantI("AST__BLOCKAVE");
        private static final int AST__UKERN1 = AstObject.getAstConstantI("AST__UKERN1");
        private static final int AST__UINTERP = AstObject.getAstConstantI("AST__UINTERP");

        private Interpolator(int scheme, double[] params) {
            this.scheme = scheme;
            this.params = new double[8];
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    this.params[i] = params[i];
                    ++i;
                }
            }
        }

        public static Interpolator nearest() {
            return new Interpolator(AST__NEAREST, null);
        }

        public static Interpolator linear() {
            return new Interpolator(AST__LINEAR, null);
        }

        public static Interpolator sinc(int npix) {
            return new Interpolator(AST__SINC, new double[]{npix});
        }

        public static Interpolator sincSinc(int npix, double width) {
            return new Interpolator(AST__SINCSINC, new double[]{npix, width});
        }

        public static Interpolator sincCos(int npix, double width) {
            return new Interpolator(AST__SINCCOS, new double[]{npix, width});
        }

        public static Interpolator sincGauss(int npix, double fwhm) {
            return new Interpolator(AST__SINCGAUSS, new double[]{npix, fwhm});
        }

        public static Interpolator blockAve(int npix) {
            return new Interpolator(AST__BLOCKAVE, new double[]{npix});
        }

        public static Interpolator ukern1(Ukern1Calculator ukern1er, int npix) {
            Interpolator interp = new Interpolator(AST__UKERN1, new double[]{npix});
            interp.ukern1er = ukern1er;
            return interp;
        }

        public static Interpolator uinterp(UinterpCalculator uinterper) {
            Interpolator interp = new Interpolator(AST__UINTERP, null);
            interp.uinterper = uinterper;
            return interp;
        }
    }
}

