/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.AstroCoords;
import uk.ac.starlink.ast.KeyMap;
import uk.ac.starlink.ast.Region;

public abstract class Stc
extends Region {
    private static final String STCNAME = AstObject.getAstConstantC("AST__STCNAME");
    private static final String STCVALUE = AstObject.getAstConstantC("AST__STCVALUE");
    private static final String STCERROR = AstObject.getAstConstantC("AST__STCERROR");
    private static final String STCRES = AstObject.getAstConstantC("AST__STCRES");
    private static final String STCSIZE = AstObject.getAstConstantC("AST__STCSIZE");
    private static final String STCPIXSZ = AstObject.getAstConstantC("AST__STCPIXSZ");

    Stc() {
    }

    public native int getStcNCoord();

    public AstroCoords getStcCoord(int i) {
        return Stc.keyMapToAstroCoords(this.getStcCoordKeyMap(i));
    }

    private native KeyMap getStcCoordKeyMap(int var1);

    static KeyMap astroCoordsToKeyMap(AstroCoords astroCoords) {
        Region pixSize;
        Region size;
        Region res;
        Region error;
        Region value;
        KeyMap kmap = new KeyMap();
        String[] axisNames = astroCoords.getName();
        if (axisNames != null && axisNames.length > 0) {
            kmap.mapPut1C(STCNAME, axisNames, "STC axis names");
        }
        if ((value = astroCoords.getValue()) != null) {
            kmap.mapPut0A(STCVALUE, value, "STC value");
        }
        if ((error = astroCoords.getError()) != null) {
            kmap.mapPut0A(STCERROR, error, "STC error");
        }
        if ((res = astroCoords.getResolution()) != null) {
            kmap.mapPut0A(STCRES, res, "STC resolution");
        }
        if ((size = astroCoords.getSize()) != null) {
            kmap.mapPut0A(STCSIZE, size, "STC size");
        }
        if ((pixSize = astroCoords.getPixSize()) != null) {
            kmap.mapPut0A(STCPIXSZ, pixSize, "STC pixel size");
        }
        return kmap;
    }

    static AstroCoords keyMapToAstroCoords(KeyMap keyMap) {
        AstObject pixsz;
        AstObject size;
        AstObject res;
        AstObject error;
        AstObject value;
        AstroCoords ac = new AstroCoords();
        if (keyMap.mapType(STCNAME) == KeyMap.AST__STRINGTYPE) {
            ac.setName(keyMap.mapGet1C(STCNAME, 100));
        }
        if (keyMap.mapType(STCVALUE) == KeyMap.AST__OBJECTTYPE && (value = keyMap.mapGet0A(STCVALUE)) instanceof Region) {
            ac.setValue((Region)value);
        }
        if (keyMap.mapType(STCERROR) == KeyMap.AST__OBJECTTYPE && (error = keyMap.mapGet0A(STCERROR)) instanceof Region) {
            ac.setError((Region)error);
        }
        if (keyMap.mapType(STCRES) == KeyMap.AST__OBJECTTYPE && (res = keyMap.mapGet0A(STCRES)) instanceof Region) {
            ac.setResolution((Region)res);
        }
        if (keyMap.mapType(STCSIZE) == KeyMap.AST__OBJECTTYPE && (size = keyMap.mapGet0A(STCSIZE)) instanceof Region) {
            ac.setSize((Region)size);
        }
        if (keyMap.mapType(STCPIXSZ) == KeyMap.AST__OBJECTTYPE && (pixsz = keyMap.mapGet0A(STCPIXSZ)) instanceof Region) {
            ac.setPixSize((Region)pixsz);
        }
        return ac;
    }

    static KeyMap[] astroCoordsToKeyMaps(AstroCoords[] coords) {
        if (coords == null) {
            return null;
        }
        KeyMap[] kmaps = new KeyMap[coords.length];
        int i = 0;
        while (i < coords.length) {
            kmaps[i] = Stc.astroCoordsToKeyMap(coords[i]);
            ++i;
        }
        return kmaps;
    }

    public native Region getStcRegion();
}

