/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.grf;

import java.awt.Font;
import java.util.ArrayList;

public class DefaultGrfFontManager {
    private static final DefaultGrfFontManager instance = new DefaultGrfFontManager();
    protected Font defaultFont;
    protected ArrayList fonts = new ArrayList();

    private DefaultGrfFontManager() {
        this.defaultFont = new Font("Lucida Sans", 0, 14);
        this.add(this.defaultFont);
    }

    public static DefaultGrfFontManager getReference() {
        return instance;
    }

    public int count() {
        return this.fonts.size();
    }

    public int add(Font font) {
        this.fonts.add(font);
        return this.count() - 1;
    }

    public int remove(Font font) {
        int index = this.fonts.indexOf(font);
        if (index > 0) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public void remove(int index) {
        if (index > 0) {
            this.fonts.remove(index);
        }
    }

    public int getIndex(Font font) {
        int index = this.fonts.indexOf(font);
        if (index != -1) {
            return index;
        }
        return 0;
    }

    public Font getFont(int index) {
        Font font = null;
        try {
            font = (Font)this.fonts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            font = this.defaultFont;
        }
        return font;
    }
}

