/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;

public class TerminalEnvironment
implements Environment {
    private Map valueMap;
    private Set paramSet;
    public static int NUM_TRIES = 5;

    public TerminalEnvironment(String[] args, Parameter[] params) throws UsageException {
        this.paramSet = new HashSet(params.length);
        int i = 0;
        while (i < params.length) {
            this.paramSet.add(params[i]);
            ++i;
        }
        this.valueMap = new HashMap();
        int i2 = 0;
        while (i2 < args.length) {
            boolean found = false;
            String[] pp = args[i2].split("=");
            if (pp.length == 2) {
                String name = pp[0];
                String value = pp[1];
                int j = 0;
                while (j < params.length) {
                    if (params[j].getName().equals(name)) {
                        this.valueMap.put(params[j], value);
                        found = true;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < params.length) {
                    if (params[j].getPosition() == i2 + 1) {
                        this.valueMap.put(params[j], args[i2]);
                        found = true;
                    }
                    ++j;
                }
            }
            if (!found) {
                throw new UsageException();
            }
            ++i2;
        }
    }

    public void clear(Parameter par) {
        this.valueMap.remove(par);
    }

    public void acquireValue(Parameter par) throws TaskException {
        this.acquireValue(par, NUM_TRIES);
    }

    private void acquireValue(Parameter par, int ntries) throws TaskException {
        if (ntries <= 0) {
            throw new ParameterValueException(par, "No valid value in " + NUM_TRIES + " attempts");
        }
        if (!this.paramSet.contains(par)) {
            throw new IllegalArgumentException("Unknown parameter " + par.getName() + " (programming error)");
        }
        if (!this.valueMap.containsKey(par)) {
            if (par.getDefault() != null) {
                this.valueMap.put(par, par.getDefault());
            } else {
                String value;
                String prompt = par.getPrompt();
                System.out.print(par.getName() + (prompt == null ? "" : ": " + prompt) + " > ");
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                try {
                    value = rdr.readLine();
                }
                catch (IOException e) {
                    throw new AbortException("Error getting parameter " + par, e);
                }
                if (value == null || value.equals("!!")) {
                    throw new AbortException();
                }
                if (value.equals("!")) {
                    value = "";
                }
                if (value.length() == 0) {
                    String def = par.getDefault();
                    if (par.getDefault() != null) {
                        value = def;
                    } else {
                        this.acquireValue(par, ntries - 1);
                        return;
                    }
                }
                this.valueMap.put(par, value);
            }
        }
        try {
            par.setValueFromString(this, (String)this.valueMap.get(par));
        }
        catch (ParameterValueException e) {
            System.out.println(e.getMessage());
            this.valueMap.remove(par);
            this.acquireValue(par, ntries - 1);
            return;
        }
    }

    public void clearValue(Parameter par) {
        this.valueMap.remove(par);
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public PrintStream getErrorStream() {
        return System.err;
    }
}

