/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TerminalEnvironment;
import uk.ac.starlink.task.UsageException;

public class TerminalInvoker {
    private String toolname;
    private Map taskmap;

    public TerminalInvoker(String toolname, Map taskmap) {
        this.toolname = toolname;
        this.taskmap = taskmap;
    }

    public void invoke(String[] args) throws Exception {
        String usage = "Usage: " + this.toolname + " [-help]" + " [-fulltrace] " + " [-bench ntimes] " + " taskname [args]";
        if (args.length < 1 || args[0].length() == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        String taskname = args[0].toLowerCase();
        boolean fulltrace = false;
        if (taskname.equals("-bench")) {
            int ntimes = Integer.parseInt(args[1]);
            String[] benchargs = new String[args.length - 2];
            System.arraycopy(args, 2, benchargs, 0, args.length - 2);
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < ntimes) {
                this.invoke(benchargs);
                ++i;
            }
            long finish = System.currentTimeMillis();
            System.out.println("\n    Time for " + ntimes + " iterations: " + (finish - start) + " ms\n");
            return;
        }
        if (taskname.equals("-fulltrace")) {
            fulltrace = true;
            String[] targs = new String[args.length - 1];
            System.arraycopy(args, 1, targs, 0, args.length - 1);
            args = targs;
            taskname = args[0].toLowerCase();
        }
        if (taskname.startsWith("-")) {
            System.out.println(usage);
            System.out.println("Known tasks:");
            TreeMap tmap = new TreeMap(this.taskmap);
            Iterator it = tmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                System.out.println("   " + (String)entry.getKey() + " " + TerminalInvoker.getTaskUsage((Task)entry.getValue()));
            }
            System.out.println();
            return;
        }
        if (this.taskmap.containsKey(taskname)) {
            Task task = (Task)this.taskmap.get(taskname);
            String[] taskargs = new String[args.length - 1];
            System.arraycopy(args, 1, taskargs, 0, args.length - 1);
            try {
                Parameter[] params = task.getParameters();
                TerminalEnvironment env = new TerminalEnvironment(taskargs, params);
                task.createExecutable(env).execute();
            }
            catch (ParameterValueException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (fulltrace) {
                        cause.printStackTrace(System.err);
                    } else {
                        System.err.println(cause.getMessage());
                    }
                }
                System.err.println(this.toolname + " " + taskname + ": " + e.getMessage());
            }
            catch (UsageException e) {
                System.err.println("Usage: " + this.toolname + " " + taskname + " " + TerminalInvoker.getTaskUsage(task));
                System.exit(1);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (fulltrace) {
                        cause.printStackTrace(System.err);
                    } else {
                        System.err.println(cause.getMessage());
                    }
                }
                System.err.println(this.toolname + " " + taskname + ": " + e.getMessage());
                System.exit(e.getErrorCode());
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (fulltrace) {
                        cause.printStackTrace(System.err);
                    } else {
                        System.err.println(cause.getMessage());
                    }
                }
                System.err.println(this.toolname + " " + taskname + ": " + e.getMessage());
                System.exit(1);
            }
            catch (AbortException e) {
                System.err.println(this.toolname + " " + taskname + ": User abort");
                System.exit(1);
            }
        } else {
            System.err.println(this.toolname + ": Unknown task.  Use -h for list");
        }
    }

    public static String getTaskUsage(Task task) {
        Parameter[] params = task.getParameters();
        ArrayList<Parameter> numbered = new ArrayList<Parameter>();
        ArrayList unNumbered = new ArrayList();
        int i = 0;
        while (i < params.length) {
            Parameter param = params[i];
            (param.getPosition() > 0 ? numbered : unNumbered).add(param);
            ++i;
        }
        Collections.sort(numbered, new Comparator(){

            public int compare(Object o1, Object o2) {
                int pos2;
                int pos1 = ((Parameter)o1).getPosition();
                if (pos1 < (pos2 = ((Parameter)o2).getPosition())) {
                    return -1;
                }
                if (pos2 < pos1) {
                    return 1;
                }
                throw new IllegalArgumentException("Two params have same position");
            }
        });
        ArrayList<Parameter> paramList = numbered;
        paramList.addAll(unNumbered);
        StringBuffer usage = new StringBuffer();
        Iterator it = paramList.iterator();
        while (it.hasNext()) {
            boolean optional;
            Parameter param = (Parameter)it.next();
            boolean bl = optional = param.isNullPermitted() || param.getDefault() != null;
            if (optional) {
                usage.append('[');
            }
            usage.append(param.getName());
            if (optional) {
                usage.append(']');
            }
            if (!it.hasNext()) continue;
            usage.append(' ');
        }
        return usage.toString();
    }
}

