/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.IOException;
import uk.ac.starlink.ast.Channel;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;

class ARYReadChannel
extends Channel {
    private long[] pos;
    private final int nel;
    private final HDSObject hobj;

    ARYReadChannel(HDSObject hobj) throws HDSException {
        if (!hobj.datType().startsWith("_CHAR") || hobj.datShape().length != 1) {
            throw new IllegalArgumentException("Supplied HDS object is not 1-d _CHAR array");
        }
        this.hobj = hobj;
        this.pos = new long[]{1L};
        this.nel = (int)hobj.datShape()[0];
    }

    protected String source() throws IOException {
        String line;
        try {
            line = this.hobj.datCell(this.pos).datGet0c();
            this.pos[0] = this.pos[0] + 1L;
            while (this.pos[0] <= (long)this.nel) {
                String next = this.hobj.datCell(this.pos).datGet0c();
                if (next.length() > 0 && next.charAt(0) == '+') {
                    line = line + next.substring(1);
                    this.pos[0] = this.pos[0] + 1L;
                    continue;
                }
                break;
            }
        }
        catch (HDSException e) {
            throw new IOException(e.getMessage());
        }
        return line;
    }

    protected void sink(String line) {
        throw new UnsupportedOperationException("sink() not provided");
    }
}

