/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import uk.ac.starlink.array.Type;

public class HDSType {
    private final String name;
    private final Number badValue;
    private final Type javaType;
    public static HDSType _BYTE = new HDSType("_BYTE", Type.BYTE, new Byte(-128));
    public static HDSType _UBYTE = new HDSType("_UBYTE", Type.BYTE, new Byte(-1));
    public static HDSType _WORD = new HDSType("_WORD", Type.SHORT, new Short(Short.MIN_VALUE));
    public static HDSType _UWORD = new HDSType("_UWORD", Type.INT, new Short(-1));
    public static HDSType _INTEGER = new HDSType("_INTEGER", Type.INT, new Integer(Integer.MIN_VALUE));
    public static HDSType _REAL = new HDSType("_REAL", Type.FLOAT, new Float(Float.intBitsToFloat(-8388609)));
    public static HDSType _DOUBLE = new HDSType("_DOUBLE", Type.DOUBLE, new Double(Double.longBitsToDouble(-4503599627370497L)));

    private HDSType(String name, Type javaType, Number badValue) {
        this.name = name;
        this.javaType = javaType;
        this.badValue = badValue;
    }

    public String getName() {
        return this.name;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return this.name;
    }

    public static HDSType fromJavaType(Type javaType) {
        if (javaType == Type.BYTE) {
            return _UBYTE;
        }
        if (javaType == Type.SHORT) {
            return _WORD;
        }
        if (javaType == Type.INT) {
            return _INTEGER;
        }
        if (javaType == Type.FLOAT) {
            return _REAL;
        }
        if (javaType == Type.DOUBLE) {
            return _DOUBLE;
        }
        throw new AssertionError();
    }

    public static HDSType fromName(String name) {
        if (name.equalsIgnoreCase("_BYTE")) {
            return _BYTE;
        }
        if (name.equalsIgnoreCase("_UBYTE")) {
            return _UBYTE;
        }
        if (name.equalsIgnoreCase("_WORD")) {
            return _WORD;
        }
        if (name.equalsIgnoreCase("_UWORD")) {
            return _UWORD;
        }
        if (name.equalsIgnoreCase("_INTEGER")) {
            return _INTEGER;
        }
        if (name.equalsIgnoreCase("_REAL")) {
            return _REAL;
        }
        if (name.equalsIgnoreCase("_DOUBLE")) {
            return _DOUBLE;
        }
        return null;
    }
}

