/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.swing.event.EventListenerList;
import jsky.image.gui.ImageDisplay;
import jsky.image.gui.ImageGraphicsHandler;

public class AsynchronousImageDisplay
extends ImageDisplay {
    private PlanarImage displayImage;
    private SampleModel sampleModel;
    private ColorModel colorModel;
    private TileStore tileStore;
    private int tileWidth;
    private int tileHeight;
    private int minTileX;
    private int maxTileX;
    private int minTileY;
    private int maxTileY;
    private boolean busy;
    private boolean verbose = false;
    private static Cursor busyCursor = new Cursor(3);
    private EventListenerList _listenerList = new EventListenerList();
    static /* synthetic */ Class class$uk$ac$starlink$treeview$AsynchronousImageDisplay;
    static /* synthetic */ Class class$jsky$image$gui$ImageGraphicsHandler;

    public void updateImage() {
        this.displayImage = this.getImageProcessor().getDisplayImage();
        this.sampleModel = this.displayImage.getSampleModel();
        this.colorModel = this.displayImage.getColorModel();
        this.tileWidth = this.displayImage.getTileWidth();
        this.tileHeight = this.displayImage.getTileHeight();
        this.minTileX = this.displayImage.getMinTileX();
        this.maxTileX = this.displayImage.getMinTileX() + this.displayImage.getNumXTiles() - 1;
        this.minTileY = this.displayImage.getMinTileY();
        this.maxTileY = this.displayImage.getMinTileY() + this.displayImage.getNumYTiles() - 1;
        this.tileStore = new TileStore();
        this.displayImage.addTileComputationListener(new TileComputationListener(){

            public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
                AsynchronousImageDisplay.this.tileStore.put(new Point(tileX, tileY), null);
            }

            public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
                AsynchronousImageDisplay.this.tileStore.put(new Point(tileX, tileY), null);
                situation.printStackTrace();
            }

            public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster tile) {
                AsynchronousImageDisplay.this.tileStore.cancelUnneededRequests();
                AsynchronousImageDisplay.this.tileStore.put(new Point(tileX, tileY), tile);
                Insets insets = AsynchronousImageDisplay.this.getInsets();
                int x = AsynchronousImageDisplay.this.displayImage.tileXToX(tileX) + insets.left;
                int y = AsynchronousImageDisplay.this.displayImage.tileYToY(tileY) + insets.top;
                AsynchronousImageDisplay.this.repaint(x, y, AsynchronousImageDisplay.this.tileWidth, AsynchronousImageDisplay.this.tileHeight);
            }
        });
        super.updateImage();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        int componentWidth = this.getWidth();
        int componentHeight = this.getHeight();
        g2D.setComposite(AlphaComposite.Src);
        g2D.setColor(this.getBackground());
        g2D.fillRect(0, 0, componentWidth, componentHeight);
        if (this.displayImage == null || this.sampleModel == null) {
            return;
        }
        Rectangle clipBounds = g2D.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, componentWidth, componentHeight);
        }
        Rectangle tilePoints = this.getTileSpace(clipBounds);
        int txmin = tilePoints.x;
        int tymin = tilePoints.y;
        int txmax = tilePoints.x + tilePoints.width - 1;
        int tymax = tilePoints.y + tilePoints.height - 1;
        Insets insets = this.getInsets();
        boolean iap = this.colorModel.isAlphaPremultiplied();
        int tj = tymin;
        while (tj <= tymax) {
            int ty = this.displayImage.tileYToY(tj);
            int ti = txmin;
            while (ti <= txmax) {
                int tx = this.displayImage.tileXToX(ti);
                Point tpt = new Point(ti, tj);
                Raster tile = this.tileStore.get(tpt);
                if (tile == null) {
                    this.tileStore.queue(tpt);
                } else {
                    DataBuffer dataBuffer = tile.getDataBuffer();
                    if (dataBuffer != null) {
                        WritableRaster wr = Raster.createWritableRaster(this.sampleModel, dataBuffer, null);
                        BufferedImage bi = new BufferedImage(this.colorModel, wr, iap, null);
                        AffineTransform translator = AffineTransform.getTranslateInstance(tx + insets.left, ty + insets.top);
                        g2D.drawRenderedImage(bi, translator);
                    }
                }
                ++ti;
            }
            ++tj;
        }
    }

    private Rectangle getTileSpace(Rectangle pixelSpace) {
        int txmin = this.displayImage.XToTileX(pixelSpace.x);
        txmin = Math.max(txmin, this.minTileX);
        txmin = Math.min(txmin, this.maxTileX);
        int txmax = this.displayImage.XToTileX(pixelSpace.x + pixelSpace.width - 1);
        txmax = Math.max(txmax, this.minTileX);
        txmax = Math.min(txmax, this.maxTileX);
        int tymin = this.displayImage.YToTileY(pixelSpace.y);
        tymin = Math.max(tymin, this.minTileY);
        tymin = Math.min(tymin, this.maxTileY);
        int tymax = this.displayImage.YToTileY(pixelSpace.y + pixelSpace.height - 1);
        tymax = Math.max(tymax, this.minTileY);
        tymax = Math.min(tymax, this.maxTileY);
        return new Rectangle(txmin, tymin, txmax - txmin + 1, tymax - tymin + 1);
    }

    private void setBusy(boolean busy) {
        this.busy = busy;
        this.setCursor(busy ? busyCursor : null);
        this.log("busy: " + busy);
    }

    private void log(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    public void addImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.add(class$jsky$image$gui$ImageGraphicsHandler == null ? (class$jsky$image$gui$ImageGraphicsHandler = AsynchronousImageDisplay.class$("jsky.image.gui.ImageGraphicsHandler")) : class$jsky$image$gui$ImageGraphicsHandler, igh);
    }

    public void removeImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.remove(class$jsky$image$gui$ImageGraphicsHandler == null ? (class$jsky$image$gui$ImageGraphicsHandler = AsynchronousImageDisplay.class$("jsky.image.gui.ImageGraphicsHandler")) : class$jsky$image$gui$ImageGraphicsHandler, igh);
    }

    private void _notifyGraphicsHandlers(Graphics2D g) {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$jsky$image$gui$ImageGraphicsHandler == null ? AsynchronousImageDisplay.class$("jsky.image.gui.ImageGraphicsHandler") : class$jsky$image$gui$ImageGraphicsHandler)) {
                ((ImageGraphicsHandler)listeners[i + 1]).drawImageGraphics(this, g);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TileStore {
        private Map tileMap = new HashMap();
        private Map tileRefs = new HashMap();
        private Map tileRequests = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        private TileStore() {
        }

        public synchronized void queue(Point pt) {
            if (!this.tileRequests.containsKey(pt)) {
                TileRequest req = AsynchronousImageDisplay.this.displayImage.queueTiles(new Point[]{pt});
                this.tileRequests.put(pt, req);
                AsynchronousImageDisplay.this.setBusy(true);
                AsynchronousImageDisplay.this.log("Order:\t" + pt);
            }
        }

        public synchronized void cancelUnneededRequests() {
            boolean showing = AsynchronousImageDisplay.this.isShowing();
            Rectangle visibleTiles = AsynchronousImageDisplay.this.getTileSpace(AsynchronousImageDisplay.this.getVisibleRect());
            int txmin = visibleTiles.x;
            int tymin = visibleTiles.y;
            int txmax = visibleTiles.x + visibleTiles.width - 1;
            int tymax = visibleTiles.y + visibleTiles.height - 1;
            Iterator it = this.tileRequests.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = it.next();
                Point pt = (Point)ent.getKey();
                if (showing && pt.x >= txmin && pt.x <= txmax && pt.y >= tymin && pt.y <= tymax) continue;
                TileRequest req = (TileRequest)ent.getValue();
                Point[] reqpts = req.getTileIndices();
                if (!$assertionsDisabled && reqpts.length != 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !reqpts[0].equals(pt)) {
                    throw new AssertionError();
                }
                req.cancelTiles(req.getTileIndices());
                it.remove();
                this.tileMap.remove(pt);
                AsynchronousImageDisplay.this.log("Cancel:\t" + pt + "  " + (showing ? txmin + ".." + txmax + ", " + tymin + ".." + tymax : "hidden"));
            }
            if (this.tileRequests.isEmpty()) {
                AsynchronousImageDisplay.this.setBusy(false);
            }
        }

        public synchronized void put(Point pt, Raster raster) {
            Record rec;
            if (this.tileMap.containsKey(pt)) {
                rec = (Record)this.tileMap.get(pt);
                ++rec.refCount;
            } else {
                rec = new Record();
                rec.raster = raster;
                this.tileMap.put(pt, rec);
                this.tileRefs.put(pt, new WeakReference<Raster>(raster));
            }
            AsynchronousImageDisplay.this.log("Put:\t" + pt + " " + rec.refCount);
        }

        public synchronized Raster get(Point pt) {
            Raster raster;
            Record rec = (Record)this.tileMap.get(pt);
            if (rec != null) {
                raster = rec.raster;
                AsynchronousImageDisplay.this.log("Buy:\t" + pt + " " + rec.refCount);
                if (--rec.refCount == 0) {
                    this.tileMap.remove(pt);
                    this.tileRequests.remove(pt);
                    if (this.tileRequests.isEmpty()) {
                        AsynchronousImageDisplay.this.setBusy(false);
                    }
                }
            } else if (this.tileRefs.containsKey(pt)) {
                Reference ref = (Reference)this.tileRefs.get(pt);
                raster = (Raster)ref.get();
                if (raster == null) {
                    AsynchronousImageDisplay.this.log("Gone:\t" + pt);
                    this.tileRefs.remove(pt);
                } else {
                    AsynchronousImageDisplay.this.log("Steal:\t" + pt);
                }
            } else {
                raster = null;
            }
            return raster;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$treeview$AsynchronousImageDisplay == null ? (class$uk$ac$starlink$treeview$AsynchronousImageDisplay = AsynchronousImageDisplay.class$("uk.ac.starlink.treeview.AsynchronousImageDisplay")) : class$uk$ac$starlink$treeview$AsynchronousImageDisplay).desiredAssertionStatus();
        }

        private class Record {
            int refCount = 1;
            Raster raster;

            private Record() {
            }
        }
    }
}

