/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.splat.data.AbstractSpecDataImpl;
import uk.ac.starlink.splat.data.SpecData;
import uk.ac.starlink.splat.data.SpecDataComp;
import uk.ac.starlink.splat.data.SpecDataImpl;
import uk.ac.starlink.splat.plot.DivaPlot;
import uk.ac.starlink.splat.util.SplatException;

public class GraphViewer
extends DivaPlot {
    private Dimension lastSize;

    public GraphViewer(Ndx ndx) throws SplatException, IOException {
        super(new SpecDataComp((SpecDataImpl)new NdxSpecDataImpl(ndx)));
        SpecDataComp sdcomp = this.getSpecDataComp();
        SpecData sd = sdcomp.get(0);
        if (ndx.hasVariance()) {
            sd.setDrawErrorBars(true);
        }
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        if (size.width < 250) {
            size.width = 250;
        }
        if (size.height < 150) {
            size.height = 150;
        }
        if (!size.equals(this.lastSize)) {
            this.setPreferredSize(size);
            this.fitToHeight();
            this.fitToWidth();
            this.xScale = 1.0f;
            this.yScale = 1.0f;
            this.xyScaled = true;
        }
        super.paintComponent(g);
        this.lastSize = size;
    }

    private static class NdxSpecDataImpl
    extends AbstractSpecDataImpl {
        private Ndx ndx;
        private FrameSet ast;
        private double[] imData;
        private double[] errData;
        private NDShape shape;
        private String title;
        private String label;
        private String units;

        public NdxSpecDataImpl(Ndx ndx) throws IOException, SplatException {
            super(ndx.hasTitle() ? ndx.getTitle() : null);
            this.ndx = ndx;
            this.ast = Ndxs.getAst((Ndx)ndx);
            this.shape = ndx.getImage().getShape();
            this.title = ndx.hasTitle() ? ndx.getTitle() : null;
            this.label = ndx.hasLabel() ? ndx.getLabel() : "";
            this.units = ndx.hasUnits() ? ndx.getUnits() : "";
            int npix = (int)ndx.getImage().getShape().getNumPixels();
            Requirements req = new Requirements(AccessMode.READ).setType(Type.DOUBLE).setWindow(this.shape).setBadValue((Number)new Double(-1.7976931348623157E308));
            NDArray image = Ndxs.getMaskedImage((Ndx)ndx, (Requirements)req);
            this.imData = new double[npix];
            ArrayAccess imacc = image.getAccess();
            imacc.read((Object)this.imData, 0, npix);
            imacc.close();
            if (ndx.hasVariance()) {
                NDArray errors = Ndxs.getMaskedErrors((Ndx)ndx, (Requirements)req);
                this.errData = new double[npix];
                ArrayAccess erracc = errors.getAccess();
                erracc.read((Object)this.errData, 0, npix);
                erracc.close();
            }
        }

        public FrameSet getAst() {
            return this.ast;
        }

        public double[] getData() {
            return this.imData;
        }

        public double[] getDataErrors() {
            return this.errData;
        }

        public int[] getDims() {
            return NDShape.longsToInts((long[])this.shape.getDims());
        }

        public String getFullName() {
            return null;
        }

        public String getShortName() {
            return this.title;
        }

        public String getDataFormat() {
            return "NDX";
        }

        public String getProperty(String key) {
            if (key.equals("label")) {
                return this.label;
            }
            if (key.equals("units")) {
                return this.units;
            }
            return "";
        }

        public void save() throws SplatException {
            throw new SplatException("Not built to save");
        }
    }
}

