/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;
import uk.ac.starlink.treeview.ScalingPlot;

public class GridPlotter
extends JPanel {
    private int currentFrame;

    GridPlotter(NDShape baseShape, FrameSet wcs) {
        super(new BorderLayout());
        this.currentFrame = wcs.getCurrent();
        long[] dims = baseShape.getDims();
        int ndim = baseShape.getNumDims();
        double[] lower = new double[ndim];
        double[] upper = new double[ndim];
        int i = 0;
        while (i < ndim) {
            lower[i] = 0.5;
            upper[i] = 0.5 + (double)dims[i];
            ++i;
        }
        final ScalingPlot plotPan = new ScalingPlot(wcs, lower, upper){

            protected void configurePlot(Plot plot) {
                plot.setCurrent(GridPlotter.this.currentFrame + 1);
                super.configurePlot(plot);
            }
        };
        TreeviewLAF.configureMainPanel(plotPan);
        this.add((Component)plotPan, "Center");
        int nfrm = wcs.getNframe();
        String[] frameNames = new String[nfrm];
        int i2 = 0;
        while (i2 < nfrm) {
            frameNames[i2] = i2 + 1 + ": " + wcs.getFrame(i2 + 1).getDomain();
            ++i2;
        }
        final JComboBox<String> selecter = new JComboBox<String>(frameNames);
        selecter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    GridPlotter.this.currentFrame = selecter.getSelectedIndex() + 1;
                    plotPan.refreshPlot();
                }
            }
        });
        selecter.setSelectedIndex(this.currentFrame - 1);
        selecter.setMaximumSize(selecter.getPreferredSize());
        Box controlBox = new Box(0);
        controlBox.add(new JLabel("Plotted co-ordinate frame: "));
        controlBox.add(selecter);
        controlBox.add(Box.createGlue());
        TreeviewLAF.configureControlPanel(controlBox);
        this.add((Component)controlBox, "North");
    }
}

