/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;

public class ScalingPlot
extends JPanel {
    private final FrameSet wcs;
    private final double[] lower;
    private final double[] upper;
    private final double[] bbox;
    private final double gridAspect;
    private final int lgap;
    private final int rgap;
    private final int tgap;
    private final int bgap;
    private Plot plot;
    private Dimension lastSize;

    public ScalingPlot(FrameSet wcs, double[] lower, double[] upper) {
        if (lower.length != 2 || upper.length != 2 || wcs.getFrame(FrameSet.AST__BASE).getNaxes() != 2) {
            throw new IllegalArgumentException("Not a 2d WCS");
        }
        this.wcs = (FrameSet)wcs.copy();
        this.lower = (double[])lower.clone();
        this.upper = (double[])upper.clone();
        this.bbox = new double[]{lower[0], lower[1], upper[0], upper[1]};
        this.gridAspect = (upper[1] - lower[1]) / (upper[0] - lower[0]);
        int[] pixelBounds = this.getPixelBounds();
        this.lgap = pixelBounds[0];
        this.rgap = pixelBounds[1];
        this.tgap = pixelBounds[2];
        this.bgap = pixelBounds[3];
    }

    protected void configurePlot(Plot plot) {
        plot.setGrid(true);
        plot.clear();
        plot.grid();
    }

    protected int[] getPixelBounds() {
        return new int[]{70, 30, 40, 60};
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        if (size.width < this.lgap + this.rgap + 150) {
            size.width = this.lgap + this.rgap + 150;
        }
        if (size.height < this.tgap + this.bgap + 150) {
            size.height = this.tgap + this.bgap + 150;
        }
        if (!size.equals(this.lastSize)) {
            this.lastSize = size;
            this.makeNewPlot();
        }
        this.plot.paint(g);
    }

    public void refreshPlot() {
        if (this.plot != null) {
            this.lastSize = null;
            this.repaint();
        }
    }

    private void makeNewPlot() {
        Dimension size = this.getSize();
        Dimension plotWindow = new Dimension(size);
        plotWindow.width -= this.lgap + this.rgap;
        plotWindow.height -= this.tgap + this.bgap;
        double windowAspect = (double)plotWindow.height / (double)plotWindow.width;
        Dimension plotSize = new Dimension();
        if (this.gridAspect < windowAspect) {
            plotSize.width = plotWindow.width;
            plotSize.height = (int)Math.round((double)plotSize.width * this.gridAspect);
        } else {
            plotSize.height = plotWindow.height;
            plotSize.width = (int)Math.round((double)plotSize.height / this.gridAspect);
        }
        Rectangle position = new Rectangle(plotSize);
        position.x = this.lgap + (size.width - (this.lgap + plotSize.width + this.rgap)) / 2;
        position.y = this.tgap + (size.height - (this.tgap + plotSize.height + this.bgap)) / 2;
        this.plot = new Plot((Frame)this.wcs, (Rectangle2D)position, this.bbox);
        this.configurePlot(this.plot);
        this.setPreferredSize(plotSize);
    }
}

