/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.splat.data.NDXSpecDataImpl;
import uk.ac.starlink.splat.data.SpecData;
import uk.ac.starlink.splat.data.SpecDataImpl;
import uk.ac.starlink.splat.iface.SplatBrowser;
import uk.ac.starlink.splat.iface.SplatBrowserMain;
import uk.ac.starlink.splat.util.SplatException;
import uk.ac.starlink.treeview.NdxDisplayer;

public class SplatNdxDisplayer
extends NdxDisplayer {
    private SplatBrowser browser;
    private static SplatNdxDisplayer instance;

    public SplatNdxDisplayer() {
        super("http://localhost:8081/services/SplatSOAPServices", "displayNDX");
    }

    public static synchronized SplatNdxDisplayer getInstance() {
        if (instance == null) {
            instance = new SplatNdxDisplayer();
        }
        return instance;
    }

    public boolean canDisplay(Ndx ndx) {
        return super.canDisplay(ndx) && NodeUtil.hasAST();
    }

    public boolean localDisplay(Ndx ndx, boolean embedded) {
        try {
            SpecData spectrum = new SpecData((SpecDataImpl)new NDXSpecDataImpl(ndx));
            SplatBrowser browser = this.getBrowser(embedded);
            browser.addSpectrum(spectrum);
            browser.displaySpectrum(spectrum);
            return true;
        }
        catch (SplatException e) {
            return false;
        }
    }

    private synchronized SplatBrowser getBrowser(boolean embedded) {
        if (this.browser == null) {
            SplatBrowserMain.guessProperties((boolean)false);
            this.browser = new SplatBrowser(embedded);
        }
        this.browser.setVisible(true);
        return this.browser;
    }
}

