/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.PiecewiseConstant;
import JSci.maths.wavelet.splines.Spline;

public class LinearSpline
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 1;
    private double[] vecteur;
    static final double[] vg = new double[]{0.5, 1.0, 0.5};
    static final double[] v0 = new double[]{1.0, 0.5};

    public int getFilterType() {
        return 1;
    }

    public String toString() {
        return ArrayMath.toString((double[])this.vecteur);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LinearSpline && this.vecteur.length == ((LinearSpline)object).dimension()) {
            LinearSpline linearSpline = (LinearSpline)object;
            int n = 0;
            while (n < this.vecteur.length) {
                if (this.vecteur[n] != linearSpline.getValue(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)(n + 1) / 2.0);
        if (2 * n2 - 1 == n) {
            return n2;
        }
        throw new IllegalArgumentException("Even number of values into an odd Filter! Change the number of data values/of iterations.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = new double[2 * dArray.length - 1];
        int n = 1;
        while (n < dArray.length - 1) {
            int n2 = 2 * n - 1;
            dArray2[n2] = dArray2[n2] + dArray[n] * vg[0];
            int n3 = 2 * n;
            dArray2[n3] = dArray2[n3] + dArray[n] * vg[1];
            int n4 = 2 * n + 1;
            dArray2[n4] = dArray2[n4] + dArray[n] * vg[2];
            ++n;
        }
        dArray2[0] = dArray2[0] + v0[0] * dArray[0];
        dArray2[1] = dArray2[1] + v0[1] * dArray[0];
        int n5 = dArray2.length - 1;
        dArray2[n5] = dArray2[n5] + v0[0] * dArray[dArray.length - 1];
        int n6 = dArray2.length - 2;
        dArray2[n6] = dArray2[n6] + v0[1] * dArray[dArray.length - 1];
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        return this.lowpass(dArray);
    }

    public LinearSpline(double[] dArray) {
        this.vecteur = dArray;
    }

    public LinearSpline() {
    }

    public Object clone() {
        LinearSpline linearSpline = (LinearSpline)super.clone();
        if (this.vecteur != null) {
            linearSpline.vecteur = ArrayMath.copy((double[])this.vecteur);
        }
        return linearSpline;
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameter : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive: " + n);
        }
        this.vecteur[n] = d;
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public PiecewiseConstant derive() {
        return this.derive(0.0, 1.0);
    }

    public PiecewiseConstant derive(double d, double d2) {
        double[] dArray = new double[this.vecteur.length - 1];
        int n = 0;
        while (n < this.vecteur.length - 1) {
            dArray[n] = (this.vecteur[n + 1] - this.vecteur[n]) * (double)(this.vecteur.length - 1) / Math.abs(d2 - d);
            ++n;
        }
        PiecewiseConstant piecewiseConstant = new PiecewiseConstant(dArray);
        return piecewiseConstant;
    }

    public int dimension() {
        return this.vecteur.length;
    }

    public int dimension(int n) {
        return Cascades.dimension(this.vecteur.length, n);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

