/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class AbstractStarTable
implements StarTable {
    private List parameters = new ArrayList();
    private String name;
    private URL url;

    public List getColumnAuxDataInfos() {
        TreeMap<String, ValueInfo> auxMap = new TreeMap<String, ValueInfo>();
        int i = 0;
        while (i < this.getColumnCount()) {
            Iterator it = this.getColumnInfo(i).getAuxData().iterator();
            while (it.hasNext()) {
                DescribedValue dval = (DescribedValue)it.next();
                ValueInfo info = dval.getInfo();
                String name = info.getName();
                if (auxMap.containsKey(name)) {
                    ValueInfo oldInfo = (ValueInfo)auxMap.get(name);
                    auxMap.put(name, DefaultValueInfo.generalise(oldInfo, info));
                    continue;
                }
                auxMap.put(name, info);
            }
            ++i;
        }
        return Collections.unmodifiableList(new ArrayList(auxMap.values()));
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public void setParameter(DescribedValue dval) {
        DescribedValue old = this.getParameterByName(dval.getInfo().getName());
        if (old != null) {
            this.parameters.remove(old);
        }
        this.parameters.add(dval);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public DescribedValue getParameterByName(String parname) {
        Iterator it = this.getParameters().iterator();
        while (it.hasNext()) {
            DescribedValue dval;
            Object item = it.next();
            if (!(item instanceof DescribedValue) || !parname.equals((dval = (DescribedValue)item).getInfo().getName())) continue;
            return dval;
        }
        return null;
    }

    public static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    public boolean isRandom() {
        return false;
    }

    public Object getCell(long irow, int icol) throws IOException {
        throw new UnsupportedOperationException("No random access available");
    }

    public Object[] getRow(long irow) throws IOException {
        int ncol = this.getColumnCount();
        Object[] row = new Object[ncol];
        int icol = 0;
        while (icol < ncol) {
            row[icol] = this.getCell(irow, icol);
            ++icol;
        }
        return row;
    }

    public abstract ColumnInfo getColumnInfo(int var1);

    public abstract int getColumnCount();

    public abstract long getRowCount();

    public abstract RowSequence getRowSequence() throws IOException;
}

