/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.ValueInfo;

public class BeanStarTable
extends RandomStarTable {
    private final PropertyDescriptor[] properties_;
    private final Class beanClass_;
    private Object[] data_;
    private static final ValueInfo PROGNAME_INFO = new DefaultValueInfo("ProgName", class$java$lang$String == null ? (class$java$lang$String = BeanStarTable.class$("java.lang.String")) : class$java$lang$String, "Programmatic name");
    private static final Object[] NO_ARGS = new Object[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public BeanStarTable(Class clazz) throws IntrospectionException {
        this.beanClass_ = clazz;
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Can't do primitive class");
        }
        BeanInfo info = Introspector.getBeanInfo(clazz);
        ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>(Arrays.asList(info.getPropertyDescriptors()));
        Iterator it = propList.iterator();
        while (it.hasNext()) {
            PropertyDescriptor prop = (PropertyDescriptor)it.next();
            if (BeanStarTable.useProperty(prop)) continue;
            it.remove();
        }
        this.properties_ = propList.toArray(new PropertyDescriptor[0]);
        this.data_ = (Object[])Array.newInstance(clazz, 0);
    }

    public void setData(Object[] data) {
        if (!this.beanClass_.isAssignableFrom(data.getClass().getComponentType())) {
            throw new ClassCastException(data.getClass().getName() + " is not " + this.beanClass_.getName() + "[]");
        }
        this.data_ = data;
    }

    public Object[] getData() {
        return this.data_;
    }

    public long getRowCount() {
        return this.data_.length;
    }

    public int getColumnCount() {
        return this.properties_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        PropertyDescriptor prop = this.properties_[icol];
        String name = prop.getDisplayName();
        String description = prop.getShortDescription();
        String progName = prop.getName();
        Class clazz = BeanStarTable.getObjectType(prop.getPropertyType());
        ColumnInfo cinfo = new ColumnInfo(new DefaultValueInfo(name, clazz, description));
        if (progName != null && progName.trim().length() > 0) {
            cinfo.setAuxDatum(new DescribedValue(PROGNAME_INFO, progName));
        }
        return cinfo;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.getProperty(this.data_[AbstractStarTable.checkedLongToInt(irow)], icol);
    }

    public Object getProperty(Object bean, int iprop) throws IOException {
        try {
            return this.properties_[iprop].getReadMethod().invoke(bean, NO_ARGS);
        }
        catch (IllegalAccessException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Introspector said it would be OK"))).initCause(e));
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            if (e2 instanceof Error) {
                throw (Error)e2;
            }
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
    }

    private static boolean useProperty(PropertyDescriptor prop) {
        Class<?> pclazz = prop.getPropertyType();
        return prop.getReadMethod() != null && !prop.isHidden() && (pclazz == (class$java$lang$String == null ? (class$java$lang$String = BeanStarTable.class$("java.lang.String")) : class$java$lang$String) || pclazz.isPrimitive());
    }

    private static Class getObjectType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanStarTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (clazz == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = BeanStarTable.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (clazz == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = BeanStarTable.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (clazz == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = BeanStarTable.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (clazz == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = BeanStarTable.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (clazz == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = BeanStarTable.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (clazz == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = BeanStarTable.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (clazz == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = BeanStarTable.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

