/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomWrapperStarTable;
import uk.ac.starlink.table.StarTable;

public class ColumnRandomWrapperStarTable
extends RandomWrapperStarTable {
    private int ncol;
    private int nrow;
    private ArrayColumn[] columns;
    private long currentRow = 0L;

    public ColumnRandomWrapperStarTable(StarTable baseTable, int nrow) throws IOException {
        super(baseTable);
        this.nrow = nrow;
        this.ncol = this.getColumnCount();
        this.columns = new ArrayColumn[this.ncol];
        int icol = 0;
        while (icol < this.ncol) {
            ColumnInfo colinfo = this.getColumnInfo(icol);
            this.columns[icol] = ArrayColumn.makeColumn(colinfo, nrow);
            ++icol;
        }
    }

    public long getRowCount() {
        return this.nrow;
    }

    protected synchronized void storeNextRow(Object[] row) {
        if (this.currentRow < (long)this.nrow) {
            int icol = 0;
            while (icol < this.ncol) {
                this.columns[icol].storeValue(this.currentRow, row[icol]);
                ++icol;
            }
            ++this.currentRow;
        }
    }

    protected Object[] retrieveStoredRow(long lrow) {
        Object[] row = new Object[this.ncol];
        if (lrow < (long)this.nrow) {
            int icol = 0;
            while (icol < this.ncol) {
                row[icol] = this.columns[icol].readValue(lrow);
                ++icol;
            }
        }
        return row;
    }
}

