/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;

public class JoinStarTable
extends AbstractStarTable {
    private final StarTable[] tables;
    private final StarTable[] tablesByColumn;
    private final int[] indicesByColumn;
    private final int[] nCols;
    private final int nTab;
    private final int nCol;
    private final boolean isRandom;
    private final ColumnInfo[] colInfos;
    private final List auxData;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$JoinStarTable;

    public JoinStarTable(StarTable[] tables, JoinFixAction[] fixCols) {
        this.nTab = tables.length;
        this.tables = (StarTable[])tables.clone();
        if (fixCols == null) {
            fixCols = new JoinFixAction[this.nTab];
            Arrays.fill(fixCols, JoinFixAction.NO_ACTION);
        }
        if (fixCols.length != this.nTab) {
            throw new IllegalArgumentException("Incompatible length of array arguments");
        }
        int nc = 0;
        this.nCols = new int[this.nTab];
        int itab = 0;
        while (itab < this.nTab) {
            this.nCols[itab] = tables[itab].getColumnCount();
            nc += this.nCols[itab];
            ++itab;
        }
        this.nCol = nc;
        this.tablesByColumn = new StarTable[this.nCol];
        this.indicesByColumn = new int[this.nCol];
        int icol = 0;
        int itab2 = 0;
        while (itab2 < this.nTab) {
            int ic = 0;
            while (ic < this.nCols[itab2]) {
                this.tablesByColumn[icol] = tables[itab2];
                this.indicesByColumn[icol] = ic++;
                ++icol;
            }
            ++itab2;
        }
        if (!$assertionsDisabled && icol != this.nCol) {
            throw new AssertionError();
        }
        this.colInfos = new ColumnInfo[this.nCol];
        HashSet colNames = new HashSet();
        HashSet<String> colDups = new HashSet<String>();
        icol = 0;
        int itab3 = 0;
        while (itab3 < this.nTab) {
            int ic = 0;
            while (ic < this.nCols[itab3]) {
                this.colInfos[icol] = new ColumnInfo(tables[itab3].getColumnInfo(ic));
                String name = this.colInfos[icol].getName();
                (colNames.contains(name) ? colDups : colNames).add(name);
                ++icol;
                ++ic;
            }
            ++itab3;
        }
        if (!$assertionsDisabled && icol != this.nCol) {
            throw new AssertionError();
        }
        icol = 0;
        int itab4 = 0;
        while (itab4 < this.nTab) {
            int ic = 0;
            while (ic < this.nCols[itab4]) {
                String name = this.colInfos[icol].getName();
                boolean isDup = colDups.contains(name);
                this.colInfos[icol].setName(fixCols[itab4].getFixedName(name, isDup));
                ++icol;
                ++ic;
            }
            ++itab4;
        }
        if (!$assertionsDisabled && icol != this.nCol) {
            throw new AssertionError();
        }
        LinkedHashSet auxInfos = new LinkedHashSet();
        int itab5 = 0;
        while (itab5 < this.nTab) {
            auxInfos.addAll(tables[itab5].getColumnAuxDataInfos());
            ++itab5;
        }
        this.auxData = new ArrayList(auxInfos);
        LinkedHashSet params = new LinkedHashSet();
        int itab6 = 0;
        while (itab6 < this.nTab) {
            params.addAll(tables[itab6].getParameters());
            ++itab6;
        }
        this.setParameters(new ArrayList(params));
        boolean rand = true;
        int itab7 = 0;
        while (itab7 < this.nTab) {
            rand = rand && tables[itab7].isRandom();
            ++itab7;
        }
        this.isRandom = rand;
    }

    public JoinStarTable(StarTable[] tables) {
        this(tables, null);
    }

    public List getTables() {
        return Collections.unmodifiableList(Arrays.asList(this.tables));
    }

    public int getColumnCount() {
        return this.nCol;
    }

    public long getRowCount() {
        if (this.nTab == 0) {
            return 0L;
        }
        long nrow = Long.MAX_VALUE;
        int itab = 0;
        while (itab < this.nTab) {
            nrow = Math.min(nrow, this.tables[itab].getRowCount());
            ++itab;
        }
        return nrow;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos[icol];
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public Object getCell(long irow, int icol) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        return this.tablesByColumn[icol].getCell(irow, this.indicesByColumn[icol]);
    }

    public Object[] getRow(long irow) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        Object[] row = new Object[this.nCol];
        int icol = 0;
        int itab = 0;
        while (itab < this.nTab) {
            Object[] subrow = this.tables[itab].getRow(irow);
            System.arraycopy(subrow, 0, row, icol, this.nCols[itab]);
            icol += this.nCols[itab];
            ++itab;
        }
        if (!$assertionsDisabled && icol != this.nCol) {
            throw new AssertionError();
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        return new JoinRowSequence();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$JoinStarTable == null ? (class$uk$ac$starlink$table$JoinStarTable = JoinStarTable.class$("uk.ac.starlink.table.JoinStarTable")) : class$uk$ac$starlink$table$JoinStarTable).desiredAssertionStatus();
    }

    private class JoinRowSequence
    implements RowSequence {
        RowSequence[] rseqs;
        RowSequence[] rseqsByColumn;
        static final /* synthetic */ boolean $assertionsDisabled;

        JoinRowSequence() throws IOException {
            this.rseqs = new RowSequence[JoinStarTable.this.nTab];
            this.rseqsByColumn = new RowSequence[JoinStarTable.this.nCol];
            int icol = 0;
            int itab = 0;
            while (itab < JoinStarTable.this.nTab) {
                this.rseqs[itab] = JoinStarTable.this.tables[itab].getRowSequence();
                int ic = 0;
                while (ic < JoinStarTable.this.nCols[itab]) {
                    this.rseqsByColumn[icol] = this.rseqs[itab];
                    if (!$assertionsDisabled && JoinStarTable.this.indicesByColumn[icol] != ic) {
                        throw new AssertionError();
                    }
                    ++icol;
                    ++ic;
                }
                ++itab;
            }
            if (!$assertionsDisabled && icol != JoinStarTable.this.nCol) {
                throw new AssertionError();
            }
        }

        public boolean next() throws IOException {
            int itab = 0;
            while (itab < JoinStarTable.this.nTab) {
                if (!this.rseqs[itab].next()) {
                    return false;
                }
                ++itab;
            }
            return true;
        }

        public Object getCell(int icol) throws IOException {
            return this.rseqsByColumn[icol].getCell(JoinStarTable.this.indicesByColumn[icol]);
        }

        public Object[] getRow() throws IOException {
            Object[] row = new Object[JoinStarTable.this.nCol];
            int icol = 0;
            int itab = 0;
            while (itab < JoinStarTable.this.nTab) {
                Object[] subrow = this.rseqs[itab].getRow();
                System.arraycopy(subrow, 0, row, icol, JoinStarTable.this.nCols[itab]);
                icol += JoinStarTable.this.nCols[itab];
                ++itab;
            }
            if (!$assertionsDisabled && icol != JoinStarTable.this.nCol) {
                throw new AssertionError();
            }
            return row;
        }

        public void close() throws IOException {
            int itab = 0;
            while (itab < JoinStarTable.this.nTab) {
                this.rseqs[itab].close();
                ++itab;
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$table$JoinStarTable == null ? (class$uk$ac$starlink$table$JoinStarTable = JoinStarTable.class$("uk.ac.starlink.table.JoinStarTable")) : class$uk$ac$starlink$table$JoinStarTable).desiredAssertionStatus();
        }
    }
}

