/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;

public class RandomRowSequence
implements RowSequence {
    private StarTable startab;
    private long irow = -1L;

    public RandomRowSequence(StarTable startab) {
        this.startab = startab;
        if (!startab.isRandom()) {
            throw new IllegalArgumentException("Table " + startab + " is not random access");
        }
        long nrow = startab.getRowCount();
        if (nrow < 0L) {
            throw new IllegalArgumentException("Table " + startab + " row count unknown " + "(getRowCount()=" + nrow + ")");
        }
    }

    public boolean next() {
        if (this.irow < this.getRowCount() - 1L) {
            ++this.irow;
            return true;
        }
        return false;
    }

    public Object[] getRow() throws IOException {
        if (this.irow >= 0L) {
            return this.startab.getRow(this.irow);
        }
        throw new IllegalStateException("No current row");
    }

    public Object getCell(int icol) throws IOException {
        if (this.irow >= 0L) {
            return this.startab.getCell(this.irow, icol);
        }
        throw new IllegalStateException("No current row");
    }

    private long getRowCount() {
        long nrow = this.startab.getRowCount();
        if (nrow < 0L) {
            throw new IllegalStateException("Table " + this.startab + " row count < 0");
        }
        return nrow;
    }

    public void close() {
    }
}

