/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class RowListStarTable
extends RandomStarTable {
    private final List rows = new ArrayList();
    private final ColumnInfo[] colInfos;

    public RowListStarTable(ColumnInfo[] colInfos) {
        this.colInfos = (ColumnInfo[])colInfos.clone();
    }

    public RowListStarTable(StarTable template) {
        this(Tables.getColumnInfos(template));
        this.setName(template.getName());
        this.setParameters(new ArrayList(template.getParameters()));
    }

    public long getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.colInfos.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos[icol];
    }

    public Object getCell(long lrow, int icol) {
        return this.getRow(lrow)[icol];
    }

    public Object[] getRow(long lrow) {
        int irow = AbstractStarTable.checkedLongToInt(lrow);
        return (Object[])this.rows.get(irow);
    }

    public void setCell(long lrow, int icol, Object value) {
        this.validateCell(icol, value);
        this.getRow((long)lrow)[icol] = value;
    }

    public void setRow(long lrow, Object[] values) {
        this.validateRow(values);
        int irow = AbstractStarTable.checkedLongToInt(lrow);
        this.rows.set(irow, values);
    }

    public void addRow(Object[] values) {
        this.validateRow(values);
        this.rows.add(values);
    }

    public void insertRow(long lrow, Object[] values) {
        this.validateRow(values);
        int irow = AbstractStarTable.checkedLongToInt(lrow);
        this.rows.add(irow, values);
    }

    public void removeRow(long lrow) {
        int irow = AbstractStarTable.checkedLongToInt(lrow);
        this.rows.remove(irow);
    }

    public void clearRows() {
        this.rows.clear();
    }

    void validateRow(Object[] values) {
        int ncol = this.getColumnCount();
        if (values.length != ncol) {
            throw new IllegalArgumentException("Row has wrong number of columns (" + values.length + " not " + ncol + ")");
        }
        int icol = 0;
        while (icol < ncol) {
            this.validateCell(icol, values[icol]);
            ++icol;
        }
    }

    void validateCell(int icol, Object value) {
        if (value != null) {
            Class<?> valClazz = value.getClass();
            Class colClazz = this.colInfos[icol].getContentClass();
            if (!colClazz.isAssignableFrom(valClazz)) {
                throw new IllegalArgumentException("Value class incompatible with column: " + value + " is " + valClazz + " not " + colClazz);
            }
        }
    }
}

