/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.sql.SQLException;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.jdbc.JDBCStarTable;
import uk.ac.starlink.table.storage.DiscardRowStore;
import uk.ac.starlink.table.storage.DiskRowStore;
import uk.ac.starlink.table.storage.ListRowStore;
import uk.ac.starlink.util.Loader;

public abstract class StoragePolicy {
    private static StoragePolicy defaultInstance_;
    private static final int MIN_DISK_CELLS = 1000;
    public static final String PREF_PROPERTY = "startable.storage";
    public static final StoragePolicy PREFER_MEMORY;
    public static final StoragePolicy PREFER_DISK;
    public static final StoragePolicy DISCARD;
    static /* synthetic */ Class class$uk$ac$starlink$table$StoragePolicy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static StoragePolicy getDefaultPolicy() {
        block5: {
            if (defaultInstance_ != null) break block5;
            try {
                String pref = System.getProperty(PREF_PROPERTY);
                if ("disk".equals(pref)) {
                    defaultInstance_ = PREFER_DISK;
                    break block5;
                }
                if ("memory".equals(pref)) {
                    defaultInstance_ = PREFER_MEMORY;
                    break block5;
                }
                if ("discard".equals(pref)) {
                    defaultInstance_ = DISCARD;
                    break block5;
                }
                StoragePolicy named = (StoragePolicy)Loader.getClassInstance(pref, class$uk$ac$starlink$table$StoragePolicy == null ? (class$uk$ac$starlink$table$StoragePolicy = StoragePolicy.class$("uk.ac.starlink.table.StoragePolicy")) : class$uk$ac$starlink$table$StoragePolicy);
                defaultInstance_ = named != null ? named : PREFER_MEMORY;
            }
            catch (SecurityException e) {
                defaultInstance_ = PREFER_MEMORY;
            }
        }
        return defaultInstance_;
    }

    public static void setDefaultPolicy(StoragePolicy policy) {
        defaultInstance_ = policy;
    }

    public abstract RowStore makeRowStore();

    public abstract RowStore makeConfiguredRowStore(StarTable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StarTable randomTable(StarTable table) throws IOException {
        if (table.isRandom()) {
            return table;
        }
        if (table instanceof JDBCStarTable) {
            try {
                ((JDBCStarTable)table).setRandom();
                return table;
            }
            catch (SQLException e) {
            }
            catch (OutOfMemoryError e) {
                // empty catch block
            }
        }
        RowStore store = this.makeConfiguredRowStore(table);
        RowSequence rseq = table.getRowSequence();
        try {
            while (rseq.next()) {
                store.acceptRow(rseq.getRow());
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
        store.endRows();
        StarTable out = store.getStarTable();
        if (!$assertionsDisabled && !out.isRandom()) {
            throw new AssertionError();
        }
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$StoragePolicy == null ? (class$uk$ac$starlink$table$StoragePolicy = StoragePolicy.class$("uk.ac.starlink.table.StoragePolicy")) : class$uk$ac$starlink$table$StoragePolicy).desiredAssertionStatus();
        PREFER_MEMORY = new StoragePolicy(){

            public RowStore makeRowStore() {
                return new ListRowStore();
            }

            public RowStore makeConfiguredRowStore(StarTable meta) {
                ListRowStore store = new ListRowStore();
                store.acceptMetadata(meta);
                return store;
            }

            public String toString() {
                return "StoragePolicy.PREFER_MEMORY";
            }
        };
        PREFER_DISK = new StoragePolicy(){

            public RowStore makeRowStore() {
                try {
                    return new DiskRowStore();
                }
                catch (SecurityException e) {
                    return new ListRowStore();
                }
                catch (IOException e) {
                    return new ListRowStore();
                }
            }

            public RowStore makeConfiguredRowStore(StarTable meta) {
                long nrow = meta.getRowCount();
                if (nrow > 0L && nrow * (long)meta.getColumnCount() < 1000L) {
                    ListRowStore store = new ListRowStore();
                    store.acceptMetadata(meta);
                    return store;
                }
                try {
                    RowStore store = this.makeRowStore();
                    store.acceptMetadata(meta);
                    return store;
                }
                catch (TableFormatException e) {
                    ListRowStore store = new ListRowStore();
                    store.acceptMetadata(meta);
                    return store;
                }
            }

            public String toString() {
                return "StoragePolicy.PREFER_DISK";
            }
        };
        DISCARD = new StoragePolicy(){

            public RowStore makeRowStore() {
                return new DiscardRowStore();
            }

            public RowStore makeConfiguredRowStore(StarTable meta) {
                DiscardRowStore store = new DiscardRowStore();
                store.acceptMetadata(meta);
                return store;
            }

            public String toString() {
                return "StoragePolicy.DISCARD";
            }
        };
    }
}

