/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.ProgressLineStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.util.Loader;

public class TableCopy {
    public static void main(String[] args) throws IOException {
        String cmdname;
        Loader.loadProperties();
        StarTableFactory treader = new StarTableFactory(false);
        StarTableOutput twriter = new StarTableOutput();
        try {
            cmdname = System.getProperty("uk.ac.starlink.table.cmdname");
        }
        catch (SecurityException e) {
            cmdname = null;
        }
        if (cmdname == null) {
            cmdname = "TableCopy";
        }
        String usage = "\nUsage: " + cmdname + " [-disk]" + " [-debug]" + " [-h[elp]]" + " [-v[erbose]]" + "\n                " + " [-ifmt <in-format>]" + " [-ofmt <out-format>]" + "\n                " + " <in-table> <out-table>\n";
        StringBuffer help = new StringBuffer(usage);
        help.append("\n   Auto-detected in-formats:\n");
        Iterator it = treader.getDefaultBuilders().iterator();
        while (it.hasNext()) {
            help.append("      ").append(((TableBuilder)it.next()).getFormatName().toLowerCase()).append('\n');
        }
        help.append("\n   Known in-formats:\n");
        Iterator it2 = treader.getKnownFormats().iterator();
        while (it2.hasNext()) {
            help.append("      ").append(((String)it2.next()).toLowerCase()).append('\n');
        }
        help.append("\n   Known out-formats:\n");
        Iterator it3 = twriter.getKnownFormats().iterator();
        while (it3.hasNext()) {
            help.append("      ").append(((String)it3.next()).toLowerCase()).append('\n');
        }
        String ifmt = null;
        String ofmt = null;
        String iloc = null;
        String oloc = null;
        boolean debug = false;
        boolean verbose = false;
        Iterator<String> it4 = Arrays.asList(args).iterator();
        while (it4.hasNext()) {
            String arg = it4.next();
            if (arg.startsWith("-") && arg.length() > 1) {
                if (arg.equals("-ifmt")) {
                    if (it4.hasNext()) {
                        ifmt = it4.next();
                        continue;
                    }
                    System.err.println(usage);
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-ofmt")) {
                    if (it4.hasNext()) {
                        ofmt = it4.next();
                        continue;
                    }
                    System.err.println(usage);
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-disk")) {
                    treader.setStoragePolicy(StoragePolicy.PREFER_DISK);
                    continue;
                }
                if (arg.equals("-debug")) {
                    debug = true;
                    continue;
                }
                if (arg.equals("-v") || arg.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("-help")) {
                    System.out.println(help);
                    return;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (iloc == null) {
                iloc = arg;
                continue;
            }
            if (oloc == null) {
                oloc = arg;
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        if (verbose) {
            Logger.getLogger("uk.ac.starlink").setLevel(Level.INFO);
        }
        if (iloc == null || oloc == null) {
            System.err.println(usage);
            System.exit(1);
        }
        try {
            StarTable startab = treader.makeStarTable(iloc, ifmt);
            if (verbose) {
                startab = new ProgressLineStarTable(startab, System.err);
            }
            twriter.writeStarTable(startab, oloc, ofmt);
        }
        catch (IOException e) {
            if (debug) {
                e.printStackTrace(System.err);
            } else {
                System.err.println();
                String msg = e.getMessage();
                System.err.println(msg != null && msg.trim().length() > 0 ? msg : e.toString());
                System.err.println(usage);
            }
            System.exit(1);
        }
    }
}

