/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

class TableSorter {
    static /* synthetic */ Class class$java$lang$Comparable;

    TableSorter() {
    }

    public static long[] getSortedOrder(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
        if (!table.isRandom()) {
            throw new IOException("Table does not have random access");
        }
        int nrow = Tables.checkedLongToInt(table.getRowCount());
        Number[] rowMap = new Number[nrow];
        int i = 0;
        while (i < nrow) {
            rowMap[i] = new Integer(i);
            ++i;
        }
        RowComparator comp = new RowComparator(table, colIndices, up, nullsLast);
        try {
            Arrays.sort(rowMap, comp);
        }
        catch (SortException e) {
            throw e.asIOException();
        }
        long[] order = new long[nrow];
        int i2 = 0;
        while (i2 < nrow) {
            order[i2] = rowMap[i2].longValue();
            ++i2;
        }
        return order;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SortException
    extends RuntimeException {
        SortException(String msg, Throwable e) {
            super(msg, e);
        }

        IOException asIOException() {
            Throwable error = this.getCause();
            return error instanceof IOException ? (IOException)error : (IOException)new IOException(this.getMessage()).initCause(error);
        }
    }

    private static class RowComparator
    implements Comparator {
        final StarTable table_;
        final int[] colIndices_;
        final boolean up_;
        final boolean nullsLast_;
        final int ncol_;

        RowComparator(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
            this.table_ = table;
            this.colIndices_ = colIndices;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.ncol_ = this.colIndices_.length;
            int icol = 0;
            while (icol < this.ncol_) {
                ColumnInfo info;
                if (!(class$java$lang$Comparable == null ? TableSorter.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom((info = table.getColumnInfo(icol)).getContentClass())) {
                    throw new IOException("Column " + info + " has no defined sort order");
                }
                ++icol;
            }
        }

        public int compare(Object o1, Object o2) {
            long irow1 = ((Number)o1).longValue();
            long irow2 = ((Number)o2).longValue();
            int c = 0;
            int i = 0;
            while (i < this.ncol_ && c == 0) {
                Object val2;
                Object val1;
                int icol = this.colIndices_[i];
                try {
                    val1 = this.table_.getCell(irow1, icol);
                    val2 = this.table_.getCell(irow2, icol);
                }
                catch (IOException e) {
                    throw new SortException("Sort Error", e);
                }
                try {
                    c = this.compareValues((Comparable)val1, (Comparable)val2);
                }
                catch (ClassCastException e) {
                    throw new SortException("Expression comparison error during sorting", e);
                }
                ++i;
            }
            return c;
        }

        private int compareValues(Comparable o1, Comparable o2) {
            boolean null1 = Tables.isBlank(o1);
            boolean null2 = Tables.isBlank(o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.up_ ^ this.nullsLast_ ? -1 : 1;
            }
            if (null2) {
                return this.up_ ^ this.nullsLast_ ? 1 : -1;
            }
            return this.up_ ? o1.compareTo(o2) : o2.compareTo(o1);
        }
    }
}

