/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.ShapeIterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.TableSorter;
import uk.ac.starlink.table.ValueInfo;

public class Tables {
    public static final ValueInfo NULL_VALUE_INFO;
    public static final DefaultValueInfo RA_INFO;
    public static final DefaultValueInfo DEC_INFO;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$Tables;

    public static StarTable randomTable(StarTable startab) throws IOException {
        return StoragePolicy.getDefaultPolicy().randomTable(startab);
    }

    public static ColumnInfo[] getColumnInfos(StarTable startab) {
        int ncol = startab.getColumnCount();
        ColumnInfo[] infos = new ColumnInfo[ncol];
        int i = 0;
        while (i < ncol) {
            infos[i] = startab.getColumnInfo(i);
            ++i;
        }
        return infos;
    }

    public static StarTable deleteColumn(StarTable startab, int icol) {
        int ncol = startab.getColumnCount();
        if (icol < 0 || icol >= ncol) {
            throw new IndexOutOfBoundsException("Deleted column " + icol + " out of range 0.." + (ncol - 1));
        }
        int[] colmap = new int[ncol - 1];
        int j = 0;
        int i = 0;
        while (i < ncol) {
            if (i != icol) {
                colmap[j++] = i;
            }
            ++i;
        }
        if (!$assertionsDisabled && j != ncol - 1) {
            throw new AssertionError();
        }
        return new ColumnPermutedStarTable(startab, colmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamStarTable(StarTable source, TableSink sink) throws IOException {
        sink.acceptMetadata(source);
        RowSequence rseq = source.getRowSequence();
        try {
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
        sink.endRows();
    }

    public static void checkTable(StarTable table) throws IOException {
        int formatChars = 100;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        boolean isRandom = table.isRandom();
        if (isRandom) {
            Tables.assertTrue(nrow >= 0L);
        }
        int[] nels = new int[ncol];
        Class[] classes = new Class[ncol];
        ColumnInfo[] colinfos = new ColumnInfo[ncol];
        int icol = 0;
        while (icol < ncol) {
            ColumnInfo cinfo;
            colinfos[icol] = cinfo = table.getColumnInfo(icol);
            classes[icol] = cinfo.getContentClass();
            int[] dims = cinfo.getShape();
            if (dims != null) {
                int ndim = dims.length;
                Tables.assertTrue(ndim > 0);
                Tables.assertTrue(cinfo.getContentClass().isArray());
                int nel = 1;
                int i = 0;
                while (i < ndim) {
                    nel *= dims[i];
                    Tables.assertTrue(dims[i] != 0);
                    if (i < ndim - 1) {
                        Tables.assertTrue(dims[i] > 0);
                    }
                    ++i;
                }
                nels[icol] = nel;
            }
            Tables.assertTrue(cinfo.getContentClass().isArray() == cinfo.isArray());
            ++icol;
        }
        RowSequence rseq = table.getRowSequence();
        try {
            rseq.getRow();
            Tables.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        long lrow = 0L;
        while (rseq.next()) {
            Object[] row = rseq.getRow();
            int icol2 = 0;
            while (icol2 < ncol) {
                boolean isNull;
                Object cell;
                Object val1 = cell = row[icol2];
                Object val2 = rseq.getCell(icol2);
                Object val3 = null;
                if (isRandom) {
                    val3 = table.getCell(lrow, icol2);
                }
                boolean bl = isNull = cell == null;
                if (isNull) {
                    Tables.assertTrue(colinfos[icol2].isNullable());
                    Tables.assertTrue(val2 == null);
                    if (isRandom) {
                        Tables.assertTrue(val3 == null);
                    }
                } else {
                    String s1 = colinfos[icol2].formatValue(val1, formatChars);
                    Tables.assertTrue(s1.equals(colinfos[icol2].formatValue(val2, formatChars)));
                    if (isRandom) {
                        Tables.assertTrue(s1.equals(colinfos[icol2].formatValue(val3, formatChars)));
                    }
                }
                if (cell != null && cell.getClass().isArray()) {
                    int nel = Array.getLength(cell);
                    if (nels[icol2] < 0) {
                        Tables.assertTrue(nel % nels[icol2] == 0);
                    } else {
                        Tables.assertTrue(nels[icol2] == nel);
                    }
                }
                if (cell != null && !classes[icol2].isAssignableFrom(cell.getClass())) {
                    throw new AssertionError((Object)("Column " + icol2 + ": " + cell + " is a " + cell.getClass().getName() + " not a " + classes[icol2].getName()));
                }
                ++icol2;
            }
            ++lrow;
        }
        rseq.close();
        if (nrow >= 0L) {
            Tables.assertTrue(lrow == nrow);
        }
    }

    public static boolean isBlank(Object value) {
        return value == null || value instanceof Float && ((Float)value).isNaN() || value instanceof Double && ((Double)value).isNaN() || value instanceof String && ((String)value).length() == 0 || value.getClass().isArray() && Array.getLength(value) == 0;
    }

    public static StarTable sortTable(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
        long[] rowMap = TableSorter.getSortedOrder(table, colIndices, up, nullsLast);
        return new RowPermutedStarTable(table, rowMap);
    }

    public static int checkedLongToInt(long lval) {
        int ival = (int)lval;
        if ((long)ival == lval) {
            return ival;
        }
        if (ival < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " < Integer.MIN_VALUE");
        }
        if (ival > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " > Integer.MAX_VALUE");
        }
        throw new AssertionError();
    }

    public static String[] getElementLabels(int[] shape) {
        if (shape == null || shape.length == 0) {
            return null;
        }
        int i = 0;
        while (i < shape.length) {
            if (shape[i] <= 0) {
                return null;
            }
            ++i;
        }
        ArrayList<String> labels = new ArrayList<String>();
        ShapeIterator it = new ShapeIterator(shape);
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            StringBuffer sbuf = new StringBuffer();
            int i2 = 0;
            while (i2 < pos.length) {
                sbuf.append('_').append(Integer.toString(pos[i2] + 1));
                ++i2;
            }
            labels.add(sbuf.toString());
        }
        return labels.toArray(new String[0]);
    }

    private static void assertTrue(boolean ok) {
        if (!ok) {
            throw new AssertionError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$Tables == null ? (class$uk$ac$starlink$table$Tables = Tables.class$("uk.ac.starlink.table.Tables")) : class$uk$ac$starlink$table$Tables).desiredAssertionStatus();
        NULL_VALUE_INFO = new DefaultValueInfo("NULL_VALUE", class$java$lang$Object == null ? (class$java$lang$Object = Tables.class$("java.lang.Object")) : class$java$lang$Object, "Integer value which represents a null");
        RA_INFO = new DefaultValueInfo("RA", class$java$lang$Number == null ? (class$java$lang$Number = Tables.class$("java.lang.Number")) : class$java$lang$Number, "Right Ascension");
        DEC_INFO = new DefaultValueInfo("Dec", class$java$lang$Number == null ? (class$java$lang$Number = Tables.class$("java.lang.Number")) : class$java$lang$Number, "Declination");
        RA_INFO.setUnitString("radians");
        DEC_INFO.setUnitString("radians");
        RA_INFO.setNullable(false);
        DEC_INFO.setNullable(false);
        RA_INFO.setUCD("POS_EQ_RA");
        DEC_INFO.setUCD("POS_EQ_DEC");
    }
}

