/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCD
implements Comparable {
    private static Map ucdMap;
    private static List ucdList;
    private static Logger logger;
    public static final String UCD_DEFINITIONS_LOC = "/uk/ac/starlink/table/text/UCDs";
    private final String id;
    private final String description;
    static /* synthetic */ Class class$uk$ac$starlink$table$UCD;

    private UCD(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Object other) {
        return this.id.compareTo(((UCD)other).id);
    }

    public static UCD getUCD(String id) {
        UCD.ensureInitialised();
        UCD ucd = (UCD)ucdMap.get(id.trim());
        return ucd;
    }

    public static Iterator getUCDs() {
        UCD.ensureInitialised();
        return ucdList.iterator();
    }

    public String toString() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    private static void ensureInitialised() {
        if (ucdMap != null) {
            return;
        }
        ucdMap = new HashMap();
        ucdList = new ArrayList();
        InputStream strm = (class$uk$ac$starlink$table$UCD == null ? (class$uk$ac$starlink$table$UCD = UCD.class$("uk.ac.starlink.table.UCD")) : class$uk$ac$starlink$table$UCD).getResourceAsStream(UCD_DEFINITIONS_LOC);
        if (strm == null) {
            logger.warning("No resource /uk/ac/starlink/table/text/UCDs was found");
            return;
        }
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(strm));
            Pattern pat = Pattern.compile("^\\s*([A-Z][^<>\\s]+)\\s+(.*?)\\s*$");
            while ((line = rdr.readLine()) != null) {
                void var3_4;
                Matcher mat = pat.matcher((CharSequence)var3_4);
                if (!mat.matches()) continue;
                String id = UCD.unEscape(mat.group(1));
                String description = UCD.unEscape(mat.group(2));
                UCD ucd = new UCD(id, description);
                ucdMap.put(id, ucd);
                ucdList.add(ucd);
            }
            Collections.sort(ucdList);
        }
        catch (IOException e) {
            logger.warning("Trouble reading /uk/ac/starlink/table/text/UCDs: " + e);
        }
    }

    private static String unEscape(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.table");
    }
}

