/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class AsciiStarTable
extends StreamStarTable {
    private List comments_;
    private boolean dataStarted_;
    static /* synthetic */ Class class$java$lang$String;

    public AsciiStarTable(DataSource datsrc) throws TableFormatException, IOException {
        super(datsrc);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StreamStarTable.Metadata obtainMetadata() throws TableFormatException, IOException {
        StreamStarTable.RowEvaluator evaluator;
        block7: {
            PushbackInputStream in = this.getInputStream();
            evaluator = new StreamStarTable.RowEvaluator();
            this.comments_ = new ArrayList();
            long lrow = 0L;
            try {
                try {
                    List row;
                    while ((row = this.readRow(in)) != null) {
                        void var5_4;
                        ++lrow;
                        evaluator.submitRow((List)var5_4);
                    }
                }
                catch (TableFormatException e) {
                    throw new TableFormatException(e.getMessage() + " at row " + lrow, e);
                }
                Object var7_6 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        StreamStarTable.Metadata meta = evaluator.getMetadata();
        if (meta.nrow_ == 0L) {
            throw new TableFormatException("No rows");
        }
        this.interpretComments(meta.colInfos_);
        this.comments_ = null;
        return meta;
    }

    private void interpretComments(ColumnInfo[] colInfos) throws IOException {
        String hline;
        List headings;
        AsciiStarTable.trimLines(this.comments_);
        int ncol = colInfos.length;
        if (this.comments_.size() > 0 && (headings = this.readHeadings(new PushbackInputStream(new ByteArrayInputStream((hline = (String)this.comments_.get(this.comments_.size() - 1)).getBytes())))).size() == ncol) {
            this.comments_.remove(this.comments_.size() - 1);
            int i = 0;
            while (i < ncol) {
                colInfos[i].setName((String)headings.get(i));
                ++i;
            }
            AsciiStarTable.trimLines(this.comments_);
        }
        if (this.comments_.size() > 0) {
            StringBuffer dbuf = new StringBuffer();
            Iterator it = this.comments_.iterator();
            while (it.hasNext()) {
                dbuf.append((String)it.next());
                if (!it.hasNext()) continue;
                dbuf.append('\n');
            }
            DefaultValueInfo descriptionInfo = new DefaultValueInfo("Description", class$java$lang$String == null ? (class$java$lang$String = AsciiStarTable.class$("java.lang.String")) : class$java$lang$String, "Comments included in text file");
            this.getParameters().add(new DescribedValue(descriptionInfo, dbuf.toString()));
        }
    }

    protected List readRow(PushbackInputStream in) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        while (cellList.size() == 0) {
            boolean startLine = true;
            boolean endLine = false;
            while (!endLine) {
                int c = in.read();
                switch ((char)c) {
                    case '\uffff': {
                        if (cellList.size() == 0) {
                            return null;
                        }
                        endLine = true;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (cellList.size() == 0) break;
                        endLine = true;
                        break;
                    }
                    case '#': {
                        if (!this.dataStarted_) {
                            this.comments_.add(this.eatLine(in));
                        } else {
                            this.eatLine(in);
                        }
                        endLine = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        in.unread(c);
                        cellList.add(this.readString(in));
                        break;
                    }
                    case '!': {
                        if (startLine) {
                            if (!this.dataStarted_) {
                                this.comments_.add(this.eatLine(in));
                            } else {
                                this.eatLine(in);
                            }
                            endLine = true;
                            break;
                        }
                    }
                    default: {
                        in.unread(c);
                        String tok = this.readToken(in);
                        cellList.add("null".equals(tok) ? "" : tok);
                    }
                }
                startLine = false;
            }
        }
        this.dataStarted_ = true;
        return cellList;
    }

    private String eatLine(InputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean done = false;
        while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': 
                case '\uffff': {
                    done = true;
                    break;
                }
                default: {
                    buffer.append((char)c);
                }
            }
        }
        return buffer.toString();
    }

    private String readString(InputStream stream) throws IOException {
        int c;
        char delimiter = (char)stream.read();
        StringBuffer buffer = new StringBuffer();
        block5: while ((c = stream.read()) != delimiter) {
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    throw new TableFormatException("End of line within a string literal");
                }
                case '\\': {
                    buffer.append((char)stream.read());
                    continue block5;
                }
                case '\uffff': {
                    throw new TableFormatException("End of file within a string literal");
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private String readToken(PushbackInputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean done = false;
        while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    stream.unread(c);
                    done = true;
                    break;
                }
                case '\t': 
                case ' ': 
                case '\uffff': {
                    done = true;
                    break;
                }
                default: {
                    buffer.append((char)c);
                }
            }
        }
        return buffer.toString();
    }

    private List readHeadings(PushbackInputStream stream) throws IOException {
        ArrayList<String> headings = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    done = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': 
                case '\'': {
                    stream.unread(c);
                    headings.add(this.readString(stream));
                    break;
                }
                case '\uffff': {
                    done = true;
                    break;
                }
                default: {
                    stream.unread(c);
                    headings.add(this.readToken(stream));
                }
            }
        }
        return headings;
    }

    private static void trimLines(List lines) {
        ListIterator it = lines.listIterator(0);
        while (it.hasNext()) {
            String line = (String)it.next();
            if (line.trim().length() != 0) break;
            it.remove();
        }
        ListIterator it2 = lines.listIterator(lines.size());
        while (it2.hasPrevious()) {
            String line = (String)it2.previous();
            if (line.trim().length() != 0) break;
            it2.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

