/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.TextTableWriter;

public class AsciiTableWriter
extends TextTableWriter {
    public AsciiTableWriter() {
        this.setWriteParameters(false);
    }

    protected String formatValue(Object val, ValueInfo vinfo, int width) {
        if (Tables.isBlank(val)) {
            return "\"\"";
        }
        String fval = vinfo.formatValue(val, width);
        if (val instanceof Number) {
            try {
                Object nval0 = vinfo.unformatString(fval);
                Number nval = (Number)val;
                int ival = nval.intValue();
                if (!(ival != (int)nval.doubleValue() || nval0 instanceof Number && ival == ((Number)nval0).intValue())) {
                    fval = val.toString();
                }
            }
            catch (RuntimeException e) {
                fval = val.toString();
            }
            int nchar = fval.length();
            StringBuffer buf = new StringBuffer(nchar);
            boolean changed = false;
            int i = 0;
            while (i < nchar) {
                char c = fval.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        changed = true;
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                ++i;
            }
            return changed ? buf.toString() : fval;
        }
        int nchar = fval.length();
        StringBuffer buf = new StringBuffer(nchar + 2);
        buf.append('\"');
        boolean quote = false;
        int i = 0;
        while (i < nchar) {
            char c = fval.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    quote = true;
                    buf.append(' ');
                    break;
                }
                case '\"': 
                case '#': 
                case '\'': 
                case '\\': {
                    quote = true;
                    buf.append('\\');
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        if (quote) {
            buf.append('\"');
            return buf.toString();
        }
        return fval;
    }

    public String getFormatName() {
        return "ascii";
    }

    protected void printSeparator(OutputStream strm, int[] colwidths) {
    }

    protected void printLine(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        strm.write(32);
        this.printItems(strm, colwidths, data);
    }

    private void printItems(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        int i = 0;
        while (i < colwidths.length) {
            strm.write(32);
            String datum = data[i];
            if (datum == null || datum.length() == 0) {
                datum = "\"\"";
            }
            strm.write(TextTableWriter.getBytes(datum));
            int padding = colwidths[i] - datum.length();
            if (padding > 0) {
                int j = 0;
                while (j < padding) {
                    strm.write(32);
                    ++j;
                }
            }
            ++i;
        }
        strm.write(10);
    }

    protected void printColumnHeads(OutputStream strm, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        String[] heads = new String[ncol];
        int i = 0;
        while (i < ncol) {
            byte[] nameBuf = TextTableWriter.getBytes(cinfos[i].getName());
            int j = 0;
            while (j < nameBuf.length) {
                switch ((char)nameBuf[j]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '#': 
                    case '\'': {
                        nameBuf[j] = 95;
                    }
                }
                ++j;
            }
            heads[i] = new String(nameBuf);
            ++i;
        }
        strm.write(35);
        this.printItems(strm, colwidths, heads);
    }

    protected void printParam(OutputStream strm, String name, String value) throws IOException {
        strm.write(35);
        strm.write(32);
        strm.write(TextTableWriter.getBytes(name));
        strm.write(58);
        strm.write(32);
        byte[] valbuf = TextTableWriter.getBytes(value);
        int i = 0;
        while (i < valbuf.length) {
            switch (valbuf[i]) {
                case 10: 
                case 13: {
                    valbuf[i] = 32;
                }
            }
            ++i;
        }
        strm.write(valbuf);
        strm.write(10);
    }
}

