/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.Tables;

public class CsvTableWriter
extends StreamStarTableWriter {
    private static final int MAX_CHARS = 10240;
    private boolean writeHeader_ = true;

    public void setWriteHeader(boolean writeHeader) {
        this.writeHeader_ = writeHeader;
    }

    public boolean getWriteHeader() {
        return this.writeHeader_;
    }

    public String getFormatName() {
        return "CSV";
    }

    public boolean looksLikeFile(String location) {
        return location.endsWith(".csv") || location.endsWith(".CSV");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable table, OutputStream ostrm) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(ostrm);
        int ncol = table.getColumnCount();
        ColumnInfo[] cinfos = Tables.getColumnInfos(table);
        RowSequence rseq = table.getRowSequence();
        try {
            if (this.getWriteHeader()) {
                String[] headRow = new String[ncol];
                int icol = 0;
                while (icol < ncol) {
                    headRow[icol] = cinfos[icol].getName();
                    ++icol;
                }
                this.writeRow(out, headRow);
            }
            String[] dataRow = new String[ncol];
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                int icol = 0;
                while (icol < ncol) {
                    dataRow[icol] = cinfos[icol].formatValue(row[icol], 10240);
                    ++icol;
                }
                this.writeRow(out, dataRow);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            ((Writer)out).flush();
            rseq.close();
            throw throwable;
        }
        ((Writer)out).flush();
        rseq.close();
    }

    private void writeRow(Writer out, String[] row) throws IOException {
        int ncol = row.length;
        int icol = 0;
        while (icol < ncol) {
            this.writeField(out, row[icol]);
            out.write(icol < ncol - 1 ? 44 : 10);
            ++icol;
        }
    }

    private void writeField(Writer out, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        int nchar = value.length();
        boolean quoted = false;
        switch (value.charAt(0)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        switch (value.charAt(nchar - 1)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        int i = 0;
        while (i < nchar && !quoted) {
            switch (value.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    quoted = true;
                }
            }
            ++i;
        }
        if (!quoted) {
            out.write(value);
        } else {
            out.write(34);
            int i2 = 0;
            while (i2 < nchar) {
                char c = value.charAt(i2);
                switch (c) {
                    case '\"': {
                        out.write(34);
                    }
                }
                out.write(c);
                ++i2;
            }
            out.write(34);
        }
    }
}

