/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.ValueInfo;

public class TextTableWriter
extends StreamStarTableWriter {
    private boolean writeParams = true;
    private int maxWidth = 30;
    private int sampledRows = 100;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public String getFormatName() {
        return "text";
    }

    public boolean looksLikeFile(String location) {
        return location.equals("-") || location.endsWith(".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream strm) throws IOException {
        Object[] row;
        int ncol = startab.getColumnCount();
        ColumnInfo[] cinfos = new ColumnInfo[ncol];
        int[] cwidths = new int[ncol];
        int[] maxWidths = new int[ncol];
        int i = 0;
        while (i < ncol) {
            cinfos[i] = startab.getColumnInfo(i);
            cwidths[i] = cinfos[i].getName().length();
            maxWidths[i] = this.getMaxWidth(cinfos[i].getContentClass());
            ++i;
        }
        boolean allRowsSampled = false;
        RowSequence srseq = startab.getRowSequence();
        try {
            long lrow = 0L;
            while (lrow < (long)this.sampledRows) {
                if (!srseq.next()) {
                    allRowsSampled = true;
                    break;
                }
                row = srseq.getRow();
                int i2 = 0;
                while (i2 < ncol) {
                    String formatted = cinfos[i2].formatValue(row[i2], maxWidths[i2]);
                    if (formatted.length() > cwidths[i2]) {
                        cwidths[i2] = formatted.length();
                    }
                    ++i2;
                }
                ++lrow;
            }
            Object var16_21 = null;
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            srseq.close();
            throw throwable;
        }
        srseq.close();
        if (!allRowsSampled) {
            int icol = 0;
            while (icol < ncol) {
                int nchar;
                int n = icol;
                cwidths[n] = cwidths[n] + 2;
                ColumnInfo cinfo = cinfos[icol];
                if (cinfo.getContentClass().equals(class$java$lang$String == null ? TextTableWriter.class$("java.lang.String") : class$java$lang$String) && (nchar = cinfo.getElementSize()) > 0) {
                    cwidths[icol] = nchar;
                }
                ++icol;
            }
        }
        int i3 = 0;
        while (i3 < ncol) {
            cwidths[i3] = Math.min(maxWidths[i3], cwidths[i3]);
            ++i3;
        }
        RowSequence rseq = startab.getRowSequence();
        try {
            if (this.writeParams) {
                String name = startab.getName();
                if (name != null && name.trim().length() > 0) {
                    this.printParam(strm, "Table name", name);
                }
                Iterator it = startab.getParameters().iterator();
                while (it.hasNext()) {
                    DescribedValue param = (DescribedValue)it.next();
                    this.printParam(strm, param.getInfo().getName(), param.getValueAsString(160));
                }
            }
            this.printColumnHeads(strm, cwidths, cinfos);
            while (rseq.next()) {
                row = rseq.getRow();
                String[] data = new String[ncol];
                int i4 = 0;
                while (i4 < ncol) {
                    data[i4] = this.formatValue(row[i4], cinfos[i4], cwidths[i4]);
                    ++i4;
                }
                this.printLine(strm, cwidths, data);
            }
            this.printSeparator(strm, cwidths);
            Object var18_25 = null;
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
    }

    public void setWriteParameters(boolean writeParams) {
        this.writeParams = writeParams;
    }

    public boolean getWriteParameters() {
        return this.writeParams;
    }

    protected String formatValue(Object val, ValueInfo vinfo, int width) {
        return vinfo.formatValue(val, width);
    }

    protected void printSeparator(OutputStream strm, int[] colwidths) throws IOException {
        int i = 0;
        while (i < colwidths.length) {
            strm.write(43);
            strm.write(45);
            int j = 0;
            while (j < colwidths[i]) {
                strm.write(45);
                ++j;
            }
            strm.write(45);
            ++i;
        }
        strm.write(43);
        strm.write(10);
    }

    protected void printColumnHeads(OutputStream strm, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        String[] heads = new String[ncol];
        int i = 0;
        while (i < ncol) {
            heads[i] = cinfos[i].getName();
            ++i;
        }
        this.printSeparator(strm, colwidths);
        this.printLine(strm, colwidths, heads);
        this.printSeparator(strm, colwidths);
    }

    protected void printLine(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        int i = 0;
        while (i < colwidths.length) {
            strm.write(124);
            strm.write(32);
            String datum = data[i] == null ? "" : data[i];
            int padding = colwidths[i] - datum.length();
            strm.write(TextTableWriter.getBytes(datum), 0, Math.min(colwidths[i], datum.length()));
            if (padding > 0) {
                int j = 0;
                while (j < padding) {
                    strm.write(32);
                    ++j;
                }
            }
            strm.write(32);
            ++i;
        }
        strm.write(124);
        strm.write(10);
    }

    protected void printParam(OutputStream strm, String name, String value) throws IOException {
        strm.write(TextTableWriter.getBytes(name));
        strm.write(58);
        strm.write(32);
        strm.write(TextTableWriter.getBytes(value));
        strm.write(10);
    }

    protected static byte[] getBytes(String str) {
        int leng = str.length();
        byte[] buf = new byte[leng];
        int i = 0;
        while (i < leng) {
            buf[i] = (byte)str.charAt(i);
            ++i;
        }
        return buf;
    }

    private int getMaxWidth(Class clazz) {
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = TextTableWriter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 13;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = TextTableWriter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 11;
        }
        return this.maxWidth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

