/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressBarStarTable
extends WrapperStarTable {
    private JProgressBar progBar_;

    public ProgressBarStarTable(StarTable baseTable) {
        this(baseTable, new JProgressBar());
    }

    public ProgressBarStarTable(StarTable baseTable, JProgressBar progBar) {
        super(baseTable);
        this.setProgressBar(progBar);
        this.setZero();
    }

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public RowSequence getRowSequence() throws IOException {
        long nrow = this.getRowCount();
        final long every = nrow > 0L ? nrow / 200L : 256L;
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            long counter;
            int irow;
            Runnable updater;
            {
                super(x0);
                this.updater = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ProgressBarStarTable.access$100(1.access$000(this.this$1)).setValue(this.this$1.irow);
                    }
                };
            }

            public boolean next() throws IOException {
                ++this.irow;
                if (--this.counter < 0L) {
                    SwingUtilities.invokeLater(this.updater);
                    this.counter = every;
                }
                if (Thread.interrupted()) {
                    throw new IOException("Operation interrupted");
                }
                return super.next();
            }

            public void close() throws IOException {
                ProgressBarStarTable.this.setZero();
                super.close();
            }

            static /* synthetic */ ProgressBarStarTable access$000(1 x0) {
                return x0.ProgressBarStarTable.this;
            }
        };
    }

    private void setZero() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressBarStarTable.this.progBar_.setMinimum(0);
                ProgressBarStarTable.this.progBar_.setValue(0);
                long nrow = ProgressBarStarTable.this.getRowCount();
                boolean determinate = nrow > 0L && nrow < Integer.MAX_VALUE;
                ProgressBarStarTable.this.progBar_.setIndeterminate(!determinate);
                if (determinate) {
                    ProgressBarStarTable.this.progBar_.setMaximum((int)nrow);
                }
            }
        });
    }
}

