/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Font;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.jdbc.Connector;

public class SQLDialog
extends JOptionPane {
    private JComboBox protoField;
    private JComboBox hostField;
    private JTextField dbField;
    private JTextField refField;
    private JTextField tableField;
    private JTextField userField;
    private JPasswordField passField;

    public SQLDialog(String refString) {
        LabelledComponentStack stack = new LabelledComponentStack();
        Font inputFont = stack.getInputFont();
        this.setMessage(stack);
        this.setOptionType(2);
        this.protoField = new JComboBox();
        this.protoField.addItem("");
        this.protoField.addItem("mysql");
        this.protoField.addItem("postgresql");
        this.protoField.setEditable(true);
        this.protoField.setFont(inputFont);
        stack.addLine("Protocol", "jdbc:", this.protoField);
        this.hostField = new JComboBox();
        this.hostField.addItem("");
        this.hostField.addItem("localhost");
        this.hostField.setEditable(true);
        this.hostField.setFont(inputFont);
        stack.addLine("Host", "://", this.hostField);
        this.dbField = new JTextField(12);
        stack.addLine("Dababase name", "/", this.dbField);
        if (refString != null) {
            this.refField = new JTextField(32);
            stack.addLine(refString, "#", this.refField);
        }
        this.userField = new JTextField(12);
        this.userField.setText(System.getProperty("user.name"));
        stack.addLine("User name", null, this.userField);
        this.passField = new JPasswordField(12);
        stack.addLine("Password", null, this.passField);
    }

    public Connector getConnector() {
        return new Connector(){
            private String baseURL;
            private String user;
            private String pass;
            {
                this.baseURL = SQLDialog.this.getBaseURL();
                this.user = SQLDialog.this.userField.getText();
                this.pass = new String(SQLDialog.this.passField.getPassword());
            }

            public Connection getConnection() throws SQLException {
                return DriverManager.getConnection(this.baseURL, this.user, this.pass);
            }
        };
    }

    public String getBaseURL() {
        return "jdbc:" + this.protoField.getSelectedItem() + "://" + this.hostField.getSelectedItem() + "/" + this.dbField.getText();
    }

    public String getRef() {
        return this.refField == null ? null : this.refField.getText();
    }

    public String getFullURL() {
        String ref = this.getRef();
        return this.getBaseURL() + (ref != null ? "#" + ref : "");
    }

    public boolean isAvailable() {
        return DriverManager.getDrivers().hasMoreElements();
    }
}

