/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.gui.FilestoreTableSaveDialog;
import uk.ac.starlink.table.gui.SQLWriteDialog;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.gui.TableSaveDialog;

public abstract class TableSaveChooser
extends JPanel {
    private final JComboBox formatSelector_;
    private final JComponent[] activeComponents_;
    private final FilestoreChooser filestoreChooser_;
    private StarTableOutput sto_;
    private JDialog dialog_;
    private JProgressBar progBar_;
    private SaveWorker worker_;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$lang$Integer;

    public TableSaveChooser() {
        this(new StarTableOutput());
    }

    public TableSaveChooser(StarTableOutput sto) {
        super(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Box actionBox = Box.createVerticalBox();
        actionBox.setBorder(emptyBorder);
        this.add((Component)actionBox, "Center");
        ArrayList<JComponent> activeList = new ArrayList<JComponent>();
        Box formatBox = Box.createHorizontalBox();
        formatBox.add(new JLabel("Output Format: "));
        this.formatSelector_ = new JComboBox(){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        formatBox.add(this.formatSelector_);
        activeList.add(this.formatSelector_);
        formatBox.setAlignmentX(0.0f);
        actionBox.add(formatBox);
        this.setTableOutput(sto);
        final JTextField locField = new JTextField(25);
        AbstractAction locAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                TableSaveChooser.this.submitLocation(locField.getText());
            }
        };
        Box locBox = Box.createHorizontalBox();
        locField.addActionListener(locAction);
        locBox.add(new JLabel("Location: "));
        locBox.add(locField);
        activeList.add(locField);
        Dimension locSize = locBox.getPreferredSize();
        locSize.width = 1024;
        locBox.setMaximumSize(locSize);
        locBox.setAlignmentX(0.0f);
        locBox.add(Box.createHorizontalStrut(5));
        JButton locButton = new JButton(locAction);
        locBox.add(locButton);
        activeList.add(locButton);
        actionBox.add(Box.createVerticalStrut(5));
        actionBox.add(locBox);
        FilestoreTableSaveDialog filestoreDialog = new FilestoreTableSaveDialog();
        this.filestoreChooser_ = filestoreDialog.getChooser();
        TableSaveDialog[] saverDialogs = new TableSaveDialog[]{filestoreDialog, new SQLWriteDialog()};
        ArrayList<JButton> buttList = new ArrayList<JButton>();
        int i = 0;
        while (i < saverDialogs.length) {
            final TableSaveDialog tsd = saverDialogs[i];
            AbstractAction saverAction = new AbstractAction(tsd.getName()){

                public void actionPerformed(ActionEvent evt) {
                    if (tsd.showSaveDialog(TableSaveChooser.this, TableSaveChooser.this.getTableOutput(), TableSaveChooser.this.formatSelector_.getModel(), TableSaveChooser.this.getTable())) {
                        TableSaveChooser.this.done();
                    }
                }
            };
            saverAction.putValue("ShortDescription", tsd.getDescription());
            JButton butt = new JButton(saverAction);
            saverAction.setEnabled(tsd.isAvailable());
            if (saverAction.isEnabled()) {
                activeList.add(butt);
            }
            buttList.add(butt);
            ++i;
        }
        JButton[] buttons = buttList.toArray(new JButton[0]);
        int nopt = buttons.length;
        int buttw = 0;
        int i2 = 0;
        while (i2 < nopt) {
            buttw = Math.max(buttw, buttons[i2].getPreferredSize().width);
            ++i2;
        }
        Box dialogBox = Box.createVerticalBox();
        int i3 = 0;
        while (i3 < nopt) {
            Dimension max = buttons[i3].getMaximumSize();
            max.width = buttw;
            buttons[i3].setMaximumSize(max);
            if (i3 > 0) {
                dialogBox.add(Box.createVerticalStrut(5));
            }
            dialogBox.add(buttons[i3]);
            ++i3;
        }
        JPanel dialogLine = new JPanel(new FlowLayout(2, 0, 0));
        dialogLine.add(dialogBox);
        dialogLine.setAlignmentX(0.0f);
        actionBox.add(Box.createVerticalStrut(10));
        actionBox.add(dialogLine);
        this.activeComponents_ = activeList.toArray(new JComponent[0]);
    }

    public void configureFromLoader(TableLoadChooser loader) {
        FilestoreChooser saveChooser = this.getFilestoreChooser();
        FilestoreChooser loadChooser = loader.getFilestoreChooser();
        if (saveChooser != null && loadChooser != null) {
            saveChooser.setModel(loadChooser.getModel());
        }
    }

    FilestoreChooser getFilestoreChooser() {
        return this.filestoreChooser_;
    }

    public void setTableOutput(StarTableOutput sto) {
        this.sto_ = sto;
        this.formatSelector_.setModel(TableSaveChooser.makeFormatBoxModel(sto));
    }

    public StarTableOutput getTableOutput() {
        return this.sto_;
    }

    public abstract StarTable getTable();

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    private JProgressBar getProgressBar() {
        return this.progBar_ == null ? new JProgressBar() : this.progBar_;
    }

    public void done() {
        if (this.dialog_ != null) {
            this.dialog_.dispose();
        }
        this.filestoreChooser_.refreshList();
    }

    private void cancel() {
        if (this.worker_ != null) {
            this.worker_.cancel();
            this.worker_ = null;
            this.setEnabled(true);
        } else if (this.dialog_ != null) {
            this.dialog_.dispose();
            this.dialog_ = null;
        }
    }

    public void showSaveDialog(Component parent) {
        this.dialog_ = this.createDialog(parent);
        this.setProgressBar(new JProgressBar());
        this.dialog_.getContentPane().add((Component)this.progBar_, "South");
        this.setEnabled(true);
        this.dialog_.pack();
        this.dialog_.show();
        this.dialog_ = null;
        this.setProgressBar(null);
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            int i = 0;
            while (i < this.activeComponents_.length) {
                this.activeComponents_[i].setEnabled(isEnabled);
                ++i;
            }
        }
        super.setEnabled(isEnabled);
    }

    public JDialog createDialog(Component parent) {
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = TableSaveChooser.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
        }
        JDialog dialog = new JDialog(frame, "Save Table", true);
        dialog.setDefaultCloseOperation(2);
        JPanel pane = new JPanel(new BorderLayout());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)pane, "Center");
        pane.setLayout(new BorderLayout());
        pane.add((Component)this, "Center");
        Box iconBox = Box.createVerticalBox();
        iconBox.add(Box.createVerticalGlue());
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.questionIcon")));
        iconBox.add(Box.createVerticalGlue());
        iconBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)iconBox, "West");
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                TableSaveChooser.this.cancel();
            }
        };
        Box cancelBox = Box.createHorizontalBox();
        cancelBox.add(Box.createHorizontalGlue());
        cancelBox.add(new JButton(cancelAction));
        cancelBox.add(Box.createHorizontalGlue());
        cancelBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)cancelBox, "South");
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    private void submitLocation(final String loc) {
        final StarTableOutput sto = this.getTableOutput();
        final String format = (String)this.formatSelector_.getSelectedItem();
        this.worker_ = new SaveWorker(this.getProgressBar(), this.getTable(), loc){

            protected void attemptSave(StarTable table) throws IOException {
                sto.writeStarTable(table, loc, format);
            }

            protected void done(boolean success) {
                if (success) {
                    TableSaveChooser.this.done();
                }
                TableSaveChooser.this.worker_ = null;
                TableSaveChooser.this.setEnabled(true);
            }
        };
        this.setEnabled(false);
        this.worker_.invoke();
    }

    private static ComboBoxModel makeFormatBoxModel(StarTableOutput sto) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("(auto)");
        Iterator it = sto.getHandlers().iterator();
        while (it.hasNext()) {
            StarTableWriter handler = (StarTableWriter)it.next();
            model.addElement(handler.getFormatName());
        }
        return model;
    }

    public static void main(String[] args) {
        final int nrow = Integer.parseInt(args[0]);
        final ColumnStarTable tab = new ColumnStarTable(){

            public long getRowCount() {
                return nrow;
            }
        };
        tab.addColumn(new ColumnData(new ColumnInfo("index", class$java$lang$Integer == null ? (class$java$lang$Integer = TableSaveChooser.class$("java.lang.Integer")) : class$java$lang$Integer, null)){

            public Object readValue(long irow) {
                return new Integer((int)(irow + 1L));
            }
        });
        new TableSaveChooser(){

            public StarTable getTable() {
                return tab;
            }
        }.showSaveDialog(null);
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

