/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.jdbc.SqlReserved;
import uk.ac.starlink.util.Loader;

public class JDBCFormatter {
    private Connection conn;
    private Map typeNames;
    private static Logger logger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$jdbc$JDBCFormatter;

    public JDBCFormatter(Connection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJDBCTable(StarTable table, String tableName) throws IOException, SQLException {
        CharSequence cmd;
        Statement stmt = this.conn.createStatement();
        try {
            cmd = "DROP TABLE " + tableName;
            logger.info((String)cmd);
            stmt.executeUpdate((String)cmd);
            logger.warning("Dropped existing table " + tableName + " to write new one");
        }
        catch (SQLException e) {
            // empty catch block
        }
        cmd = new StringBuffer();
        ((StringBuffer)cmd).append("CREATE TABLE ").append(tableName).append(" (");
        int ncol = table.getColumnCount();
        boolean[] charType = new boolean[ncol];
        int[] sqlTypes = new int[ncol];
        int[] charSizes = new int[ncol];
        boolean[] needSizes = new boolean[ncol];
        boolean needSomeSizes = false;
        int icol = 0;
        while (icol < ncol) {
            ColumnInfo colInfo = table.getColumnInfo(icol);
            sqlTypes[icol] = this.getSqlType(colInfo.getContentClass());
            if (sqlTypes[icol] == 12) {
                int leng = colInfo.getElementSize();
                if (leng > 0) {
                    charSizes[icol] = leng;
                } else {
                    needSizes[icol] = true;
                    needSomeSizes = true;
                }
            }
            ++icol;
        }
        if (needSomeSizes) {
            RowSequence rseq = table.getRowSequence();
            try {
                while (rseq.next()) {
                    int icol2 = 0;
                    while (icol2 < ncol) {
                        Object val;
                        if (needSizes[icol2] && (val = rseq.getCell(icol2)) != null) {
                            charSizes[icol2] = Math.max(charSizes[icol2], val.toString().length());
                        }
                        ++icol2;
                    }
                }
                Object var16_19 = null;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                rseq.close();
                throw throwable;
            }
            rseq.close();
            {
            }
        }
        boolean first = true;
        HashSet<String> cnames = new HashSet<String>();
        int icol3 = 0;
        while (icol3 < ncol) {
            ColumnInfo col = table.getColumnInfo(icol3);
            String colName = JDBCFormatter.fixColumnName(col.getName());
            while (cnames.contains(colName)) {
                colName = colName + "_" + (icol3 + 1);
            }
            cnames.add(colName);
            int sqlType = sqlTypes[icol3];
            String tName = this.typeName(sqlType);
            if (tName == null) {
                sqlType = 0;
                logger.warning("Can't write column " + colName + " type " + col.getClass());
            }
            if (sqlType != 0) {
                if (!first) {
                    ((StringBuffer)cmd).append(',');
                }
                first = false;
                ((StringBuffer)cmd).append(' ').append(colName).append(' ').append(tName);
                if (sqlType == 12) {
                    ((StringBuffer)cmd).append('(').append(charSizes[icol3]).append(')');
                }
            }
            ++icol3;
        }
        ((StringBuffer)cmd).append(" )");
        logger.info(((StringBuffer)cmd).toString());
        stmt.executeUpdate(((StringBuffer)cmd).toString());
        cmd = new StringBuffer();
        ((StringBuffer)cmd).append("INSERT INTO ").append(tableName).append(" VALUES(");
        first = true;
        int icol4 = 0;
        while (icol4 < ncol) {
            if (sqlTypes[icol4] != 0) {
                if (!first) {
                    ((StringBuffer)cmd).append(',');
                }
                first = false;
                ((StringBuffer)cmd).append(' ').append('?');
            }
            ++icol4;
        }
        ((StringBuffer)cmd).append(" )");
        PreparedStatement pstmt = this.conn.prepareStatement(((StringBuffer)cmd).toString());
        RowSequence rseq = table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                int pix = 0;
                int icol5 = 0;
                while (icol5 < ncol) {
                    if (sqlTypes[icol5] != 0) {
                        ++pix;
                        Object val = row[icol5];
                        if (Tables.isBlank(val)) {
                            pstmt.setObject(pix, null);
                        } else {
                            pstmt.setObject(pix, row[icol5]);
                        }
                    }
                    ++icol5;
                }
                pstmt.executeUpdate();
            }
            Object var23_30 = null;
        }
        catch (Throwable throwable) {
            Object var23_31 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
    }

    public int getSqlType(Class clazz) {
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCFormatter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return -6;
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JDBCFormatter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 5;
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCFormatter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 4;
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JDBCFormatter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return -5;
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JDBCFormatter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 6;
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JDBCFormatter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 8;
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCFormatter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return -7;
        }
        if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = JDBCFormatter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 1;
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JDBCFormatter.class$("java.lang.String")) : class$java$lang$String)) {
            return 12;
        }
        return 2004;
    }

    public String typeName(int sqlType) throws SQLException {
        Integer key;
        if (this.typeNames == null) {
            this.typeNames = JDBCFormatter.makeTypesMap(this.conn);
        }
        return this.typeNames.containsKey(key = new Integer(sqlType)) ? (String)this.typeNames.get(key) : null;
    }

    private static Map makeTypesMap(Connection conn) throws SQLException {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        ResultSet typeInfos = conn.getMetaData().getTypeInfo();
        while (typeInfos.next()) {
            String name = typeInfos.getString("TYPE_NAME");
            short id = typeInfos.getShort("DATA_TYPE");
            Integer key = new Integer(id);
            if (types.containsKey(key)) continue;
            types.put(key, name);
        }
        typeInfos.close();
        if (!types.containsKey(new Integer(0))) {
            types.put(new Integer(0), "NULL");
        }
        types.put(new Integer(12), "VARCHAR");
        JDBCFormatter.setTypeFallback(types, 6, 7);
        JDBCFormatter.setTypeFallback(types, 7, 6);
        JDBCFormatter.setTypeFallback(types, 6, 8);
        JDBCFormatter.setTypeFallback(types, 8, 6);
        JDBCFormatter.setTypeFallback(types, 5, 4);
        JDBCFormatter.setTypeFallback(types, -6, 5);
        JDBCFormatter.setTypeFallback(types, -5, 4);
        return types;
    }

    private static void setTypeFallback(Map types, int req, int fallback) {
        Integer reqKey = new Integer(req);
        Integer fallbackKey = new Integer(fallback);
        if (!types.containsKey(reqKey) && types.containsKey(fallbackKey)) {
            types.put(reqKey, types.get(fallbackKey));
        }
    }

    private static String fixColumnName(String name) {
        if ((name = name.replaceAll("[\\s\\.\\(\\)\\[\\]\\-\\+]+", "_")).length() > 64) {
            name = name.substring(0, 60);
        }
        if (SqlReserved.isReserved(name)) {
            logger.info("Renaming column " + name + " to " + name + "_ (SQL reserved word)");
            name = name + "_";
            if (!$assertionsDisabled && SqlReserved.isReserved(name)) {
                throw new AssertionError();
            }
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, SQLException {
        block4: {
            block5: {
                usage = "\nUsage: JDBCFormatter intable jdbcURL tableName\n";
                if (args.length != 3) {
                    System.err.println(usage);
                    System.exit(1);
                }
                Loader.loadProperties();
                inTable = args[0];
                jdbcUrl = args[1];
                tableName = args[2];
                intab = new StarTableFactory(false).makeStarTable(inTable);
                try {
                    conn = DriverManager.getConnection(jdbcUrl);
                    new JDBCFormatter(conn).createJDBCTable(intab, tableName);
                    break block4;
                }
                catch (SQLException e) {
                    if (e.getNextException() == null) break block5;
                    System.err.println("SQL exception chain: ");
                    nextEx = e;
                    ** while (nextEx != null)
                }
lbl-1000:
                // 1 sources

                {
                    System.err.println("   " + e);
                    nextEx = nextEx.getNextException();
                    continue;
                }
            }
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$jdbc$JDBCFormatter == null ? (class$uk$ac$starlink$table$jdbc$JDBCFormatter = JDBCFormatter.class$("uk.ac.starlink.table.jdbc.JDBCFormatter")) : class$uk$ac$starlink$table$jdbc$JDBCFormatter).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.table.jdbc");
    }
}

