/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.Connector;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCFormatter;
import uk.ac.starlink.table.jdbc.JDBCStarTable;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;

public class JDBCHandler {
    private JDBCAuthenticator auth;
    private String user;
    private String passwd;
    private boolean authDone;

    public JDBCHandler() {
        this(new TerminalAuthenticator());
    }

    public JDBCHandler(JDBCAuthenticator auth) {
        this.auth = auth;
    }

    public JDBCHandler(JDBCHandler jh) {
        this(jh.auth);
        this.user = jh.user;
        this.passwd = jh.passwd;
        this.authDone = jh.authDone;
    }

    public JDBCAuthenticator getAuthenticator() {
        return this.auth;
    }

    public void setAuthenticator(JDBCAuthenticator auth) {
        auth.getClass();
        this.auth = auth;
    }

    /*
     * Unable to fully structure code
     */
    public StarTable makeStarTable(String spec, boolean wantRandom) throws IOException {
        block9: {
            block8: {
                if (!spec.startsWith("jdbc:")) {
                    throw new IllegalArgumentException("Not a JDBC-protocol URL");
                }
                hashPos = (spec = JDBCHandler.unEscape(spec)).indexOf("#");
                if (hashPos < 0) {
                    throw new IOException("Bad JDBC specification, should be jdbc:...#SQL-query");
                }
                frag = spec.substring(hashPos + 1);
                url = spec.substring(0, hashPos);
                try {
                    connector = new Connector(){

                        public Connection getConnection() throws SQLException {
                            try {
                                return JDBCHandler.this.getConnection(url);
                            }
                            catch (IOException e) {
                                throw (SQLException)new SQLException("Authentication failed").initCause(e);
                            }
                        }
                    };
                    try {
                        return new JDBCStarTable(connector, frag, wantRandom);
                    }
                    catch (SQLException e) {
                        if (wantRandom) {
                            return new JDBCStarTable(connector, frag, false);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    sbuf = new StringBuffer().append("Error making connection ").append(url);
                    den = DriverManager.getDrivers();
                    if (!den.hasMoreElements()) break block8;
                    sbuf.append(" - known JDBC drivers:\n");
                    ** while (den.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    sbuf.append("   ").append(den.nextElement().getClass().getName()).append('\n');
                    continue;
lbl26:
                    // 1 sources

                    break block9;
                }
            }
            sbuf.append(" - no known JDBC drivers");
        }
        throw (IOException)new IOException(sbuf.toString()).initCause(e);
    }

    public void createJDBCTable(StarTable startab, String spec) throws IOException, SQLException {
        if (!spec.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Not a JDBC-protocol URL");
        }
        int hashPos = spec.indexOf("#");
        if (hashPos < 0) {
            throw new IOException("Bad JDBC specification, should be \"jdbc:...#table-name\"");
        }
        String frag = spec.substring(hashPos + 1);
        String url = spec.substring(0, hashPos);
        Connection conn = this.getConnection(url);
        new JDBCFormatter(conn).createJDBCTable(startab, frag);
    }

    private Connection getConnection(String url) throws IOException, SQLException {
        if (!this.authDone) {
            try {
                return DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                String[] authInfo = this.auth.authenticate();
                this.user = authInfo[0];
                this.passwd = authInfo[1];
                this.authDone = true;
            }
        }
        return DriverManager.getConnection(url, this.user, this.passwd);
    }

    public static boolean hasDrivers() {
        return DriverManager.getDrivers().hasMoreElements();
    }

    private static String unEscape(String url) {
        StringBuffer buf = new StringBuffer();
        Matcher m = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]").matcher(url);
        while (m.find()) {
            char c = (char)Integer.parseInt(m.group().substring(1, 3), 16);
            m.appendReplacement(buf, new String(new char[]{c}));
        }
        m.appendTail(buf);
        return buf.toString();
    }
}

